package com.bxm.localnews.user.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "第三方(微信)绑定传参实体")
public class WechatBindParam {

    @ApiModelProperty("登录标识,如果是手机号密码则传递手机号码，如果是第三方登录则传递第三方登录标识")
    private String loginName;

    @ApiModelProperty("登录类型,1:手机号、密码登录，2：QQ登录，3：微信登录，4：微博登录")
    private Byte type;

    @ApiModelProperty("用户头像路径")
    private String headImg;

    @ApiModelProperty("用户昵称")
    private String nickname;

    @ApiModelProperty("用户ID，同时也是用户的邀请码。如果是注册绑定则传递静默注册用户ID")
    private Long id;

    public String getLoginName() {
        return loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public String getHeadImg() {
        return headImg;
    }

    public void setHeadImg(String headImg) {
        this.headImg = headImg;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}
