package com.bxm.localnews.user.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 通用的业务配置，具体模块的配置需要在对应的模块内创建properties和特定的前缀接收
 *
 * @author liujia 2018/7/26 16:45
 */
@Data
@Component
@ConfigurationProperties("common.config")
public class BizConfigProperties {

    /**
     * api签名加密密钥
     */
    private String apiSignKey;

    /**
     * 推广渠道链接H5path
     */
    private String channelPath = "/register.html?inviteUserId=";

    /**
     * 区域编码
     */
    private String locationCode;

    /**
     * 区域名称
     */
    private String locationName;

}
