package com.bxm.localnews.user.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.List;


@Component
@ConfigurationProperties("homepage.config")
@Data
/***
 *  配置默认个人简介
 */
public class HomePageConfigProperties {
	/**
	 * 默认个人简介
	 */
	private String defaultPersonalProfile;

	/**
	 * 默认背景图
	 */
	private List<String> defaultBackgroundImgUrls;

	/**
	 * 个人主页分享标题
	 */
	private String shareTitle;

	/**
	 * 个人主页分享副标题
	 */
	private String shareSubTitle;

	/**
	 * 是否可以修改个人简介 true 可以 false 不能修改
	 */
	private Boolean isUpdatePersonalProfile;

}
