package com.bxm.localnews.user.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 淘宝开发平台订单相关的配置信息
 * @Author: Gonzo
 * @date  2020-04-22 17:09
 * @since 3.2.0
 */
@Component
@ConfigurationProperties("user.config.tb-open")
@Data
public class TbOpenOrderProperties {

    /**
     * 淘宝开放平台订单的请求地址
     * 正式环境 http://gw.api.taobao.com/router/rest
     *  带https https://eco.taobao.com/router/rest
     * 沙箱环境 http://gw.api.tbsandbox.com/router/rest
     *  带https https://gw.api.tbsandbox.com/router/rest
     */
    private String tbOpenOrderUrl = "https://eco.taobao.com/router/rest";

    /**
     * app key (绑定渠道会员关系时)
     * 万事通为 27650304
     * 趣淘金为 27666243
     */
    private String tbkAppKey = "27650304";

    /**
     * app secret(绑定渠道会员时)
     */
    private String tbkAppSecret = "a28530f72a39d0270762d98ba1f2273b";

    /**
     * 渠道邀请码（绑定渠道关系时）
     */
    private String relationInviteCode = "WDURY5";

    /**
     * 会员邀请码（绑定会员关系时）
     */
    private String specialInviteCode = "ZULTTV";
}
