/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.service.barrels.weight;

import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.enums.RecommendTypeEnum;
import com.bxm.localnews.user.mapper.RecommendNativeMapper;
import com.bxm.localnews.user.param.NativeRecommendContext;
import com.bxm.localnews.user.param.RecommendNativeParam;
import com.bxm.localnews.user.param.WeightParam;
import com.bxm.localnews.user.properties.RecommendProperties;
import com.bxm.localnews.user.service.barrels.AbstractBarrelChoose;
import com.bxm.localnews.user.vo.RecommendNative;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class AbstractWeightBarrelChoose
extends AbstractBarrelChoose {
    @Autowired
    private RecommendNativeMapper recommendNativeMapper;
    @Autowired
    private RedisListAdapter redisListAdapter;
    @Autowired
    private RecommendProperties recommendProperties;
    protected static final String USER_INFO = "user";
    protected static final String RECOMMEND_NATIVE_PARAM = "recommendNativeParam";
    protected static final String USER_BLOCK = "userBlock";
    protected static final String USER_IGNORE = "userIgnore";
    protected static final String USER_CACHE = "userCache";

    private KeyGenerator getKeyGenerator(NativeRecommendContext nativeRecommendContext, String strategy) {
        return RedisConfig.USER_RECOMMEND.copy().setKey(nativeRecommendContext.getRecommendCategory().toLowerCase()).appendKey((Object)strategy).appendKey((Object)nativeRecommendContext.getUserId());
    }

    private void processDataRecall(List<RecommendNative> recommendNativeList, NativeRecommendContext nativeRecommendContext) {
        Map blockUserMap = (Map)nativeRecommendContext.getParam(USER_BLOCK);
        Multimap recommendNativeMap = (Multimap)nativeRecommendContext.getParam(USER_CACHE);
        Map ignoreUserMap = (Map)nativeRecommendContext.getParam(USER_IGNORE);
        ArrayList<RecommendNative> limitUserList = new ArrayList<RecommendNative>();
        Iterator<RecommendNative> it = recommendNativeList.iterator();
        block0: while (it.hasNext()) {
            RecommendNative recommendNative = it.next();
            if (!CollectionUtils.isEmpty((Map)ignoreUserMap) && ignoreUserMap.containsKey(recommendNative.getUserId())) {
                it.remove();
                continue;
            }
            if (blockUserMap.containsKey(recommendNative.getUserId())) {
                it.remove();
                Integer blockType = (Integer)blockUserMap.get(recommendNative.getUserId());
                if (2 != blockType) continue;
                limitUserList.add(recommendNative);
                continue;
            }
            if (!recommendNativeMap.containsKey((Object)recommendNative.getUserId())) continue;
            Long lastNoteId = recommendNative.getLastNoteId();
            Collection recommendList = recommendNativeMap.get((Object)recommendNative.getUserId());
            for (RecommendNative r : recommendList) {
                Long recommendLastNoteId = r.getLastNoteId();
                if (null == lastNoteId && null == recommendLastNoteId) {
                    it.remove();
                    continue block0;
                }
                if (null == lastNoteId || !lastNoteId.equals(recommendLastNoteId)) continue;
                it.remove();
            }
        }
        recommendNativeList.addAll(limitUserList);
    }

    boolean preSameCityInvoke(NativeRecommendContext nativeRecommendContext) {
        KeyGenerator keyGenerator = this.getKeyGenerator(nativeRecommendContext, RecommendTypeEnum.SAME_CITY.getName());
        if (1 == nativeRecommendContext.getActionType()) {
            RecommendNativeParam recommendNativeParam = (RecommendNativeParam)nativeRecommendContext.getParam(RECOMMEND_NATIVE_PARAM);
            if (null == recommendNativeParam.getLocationCode()) {
                nativeRecommendContext.setHasSameCity((byte)0);
                return false;
            }
            List<RecommendNative> r = this.recommendNativeMapper.selectByCity(recommendNativeParam);
            this.redisListAdapter.remove(keyGenerator);
            if (CollectionUtils.isEmpty(r)) {
                nativeRecommendContext.setHasSameCity((byte)0);
                return false;
            }
            this.processDataRecall(r, nativeRecommendContext);
            Object[] recommendNatives = r.toArray(new RecommendNative[0]);
            this.redisListAdapter.rightPush(keyGenerator, recommendNatives);
        } else {
            int size = this.redisListAdapter.size(keyGenerator).intValue();
            if (size == 0) {
                nativeRecommendContext.setHasSameCity((byte)0);
                return false;
            }
        }
        return true;
    }

    boolean doSameCityInvoke(NativeRecommendContext nativeRecommendContext, Long num) {
        List list;
        KeyGenerator keyGenerator;
        Long size;
        if (null == num) {
            WeightParam weightParam = (WeightParam)nativeRecommendContext.getParam("weight");
            num = (long)Math.floor(weightParam.getSameCityPercent() * (double)nativeRecommendContext.getPageSize().intValue());
        }
        if ((size = this.redisListAdapter.size(keyGenerator = this.getKeyGenerator(nativeRecommendContext, RecommendTypeEnum.SAME_CITY.getName()))) < num) {
            list = this.redisListAdapter.leftIndex(keyGenerator, size - 1L, RecommendNative.class);
            this.redisListAdapter.remove(keyGenerator);
            nativeRecommendContext.setHasSameCity((byte)0);
        } else {
            list = this.redisListAdapter.leftIndex(keyGenerator, num - 1L, RecommendNative.class);
            this.redisListAdapter.leftTrim(keyGenerator, num.longValue(), size.longValue());
        }
        nativeRecommendContext.getResult().addAll(list);
        return nativeRecommendContext.getPageSize().intValue() == nativeRecommendContext.getResult().size();
    }

    boolean preNearbyInvoke(NativeRecommendContext nativeRecommendContext) {
        KeyGenerator keyGenerator = this.getKeyGenerator(nativeRecommendContext, RecommendTypeEnum.NEARBY.getName());
        if (1 == nativeRecommendContext.getActionType()) {
            RecommendNativeParam recommendNativeParam = (RecommendNativeParam)nativeRecommendContext.getParam(RECOMMEND_NATIVE_PARAM);
            List<RecommendNative> r = this.recommendNativeMapper.selectByDistance(recommendNativeParam);
            this.redisListAdapter.remove(keyGenerator);
            if (CollectionUtils.isEmpty(r)) {
                return false;
            }
            this.processDataRecall(r, nativeRecommendContext);
            Object[] recommendNatives = r.toArray(new RecommendNative[0]);
            this.redisListAdapter.rightPush(keyGenerator, recommendNatives);
        } else {
            int size = this.redisListAdapter.size(keyGenerator).intValue();
            if (size == 0) {
                return false;
            }
        }
        return true;
    }

    boolean doNearbyInvoke(NativeRecommendContext nativeRecommendContext) {
        List list;
        long num = (long)nativeRecommendContext.getPageSize().intValue() - (long)nativeRecommendContext.getResult().size();
        KeyGenerator keyGenerator = this.getKeyGenerator(nativeRecommendContext, RecommendTypeEnum.NEARBY.getName());
        long size = this.redisListAdapter.size(keyGenerator);
        if (size < num) {
            list = this.redisListAdapter.leftIndex(keyGenerator, size - 1L, RecommendNative.class);
            this.redisListAdapter.remove(keyGenerator);
        } else {
            list = this.redisListAdapter.leftIndex(keyGenerator, num - 1L, RecommendNative.class);
            this.redisListAdapter.leftTrim(keyGenerator, num, size);
        }
        if (1 == nativeRecommendContext.getHasSameCity()) {
            int i;
            List<Object> indexList = new ArrayList<Integer>();
            for (i = 0; i < list.size(); ++i) {
                indexList.add(RandomUtils.nextInt((int)0, (int)nativeRecommendContext.getResult().size()));
            }
            indexList = indexList.stream().sorted((x, y) -> x > y ? 1 : 0).collect(Collectors.toList());
            for (i = 0; i < list.size(); ++i) {
                nativeRecommendContext.getResult().add((Integer)indexList.get(i), (RecommendNative)list.get(i));
            }
        } else {
            nativeRecommendContext.getResult().addAll(list);
        }
        return nativeRecommendContext.getPageSize().intValue() == nativeRecommendContext.getResult().size();
    }
}

