/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.domain.UserAuthMapper;
import com.bxm.localnews.user.domain.UserEquipmentMapper;
import com.bxm.localnews.user.domain.UserMapper;
import com.bxm.localnews.user.dto.EquipmentDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.enums.AwardTypeEnum;
import com.bxm.localnews.user.enums.CashEnum;
import com.bxm.localnews.user.enums.CashFlowConvertTypeEnum;
import com.bxm.localnews.user.enums.CashFlowTypeEnum;
import com.bxm.localnews.user.enums.InviteRecordStateEnum;
import com.bxm.localnews.user.integration.AppVersionIntegrationService;
import com.bxm.localnews.user.integration.BizIntegrationService;
import com.bxm.localnews.user.integration.BizLogIntegrationService;
import com.bxm.localnews.user.integration.InviteRelationIntegrationService;
import com.bxm.localnews.user.integration.QuartzManageIntegrationService;
import com.bxm.localnews.user.integration.SmsIntegrationService;
import com.bxm.localnews.user.integration.UserNewsIntegrationService;
import com.bxm.localnews.user.integration.VipIntegrationService;
import com.bxm.localnews.user.param.AccountCashParam;
import com.bxm.localnews.user.param.RiskParam;
import com.bxm.localnews.user.service.CashFlowService;
import com.bxm.localnews.user.service.ChannelService;
import com.bxm.localnews.user.service.InviteRecordService;
import com.bxm.localnews.user.service.LoginService;
import com.bxm.localnews.user.service.RiskRecordService;
import com.bxm.localnews.user.service.UserAccountService;
import com.bxm.localnews.user.service.UserAuthService;
import com.bxm.localnews.user.service.UserEquipmentService;
import com.bxm.localnews.user.service.UserLoginHistoryService;
import com.bxm.localnews.user.service.UserService;
import com.bxm.localnews.user.service.UserSyncService;
import com.bxm.localnews.user.service.impl.UserParamCheckService;
import com.bxm.localnews.user.vo.InviteRecord;
import com.bxm.localnews.user.vo.LoginInfo;
import com.bxm.localnews.user.vo.LoginMeta;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserAccount;
import com.bxm.localnews.user.vo.UserAuth;
import com.bxm.localnews.user.vo.UserEquipment;
import com.bxm.newidea.component.jwt.tools.JwtTokenUtil;
import com.bxm.newidea.component.log.LogMarker;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="loginService")
@RefreshScope
public class LoginServiceImpl
extends BaseService
implements LoginService {
    @Resource
    private SmsIntegrationService smsIntegrationService;
    @Resource
    private UserAuthMapper userAuthMapper;
    @Resource
    private UserMapper userMapper;
    @Resource
    private InviteRelationIntegrationService inviteRelationIntegrationService;
    @Resource
    private UserService userService;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private AppVersionIntegrationService appVersionIntegrationService;
    @Resource
    private UserAuthService userAuthService;
    @Resource
    private BizLogIntegrationService bizLogIntegrationService;
    @Resource
    private VipIntegrationService vipIntegrationService;
    @Resource
    private UserLoginHistoryService userLoginHistoryService;
    @Resource
    private UserNewsIntegrationService userNewsIntegrationService;
    @Resource
    private UserSyncService userSyncService;
    @Resource
    private InviteRecordService inviteRecordService;
    @Resource
    private UserAccountService userAccountService;
    @Resource
    private QuartzManageIntegrationService quartzManageIntegrationService;
    @Resource
    private CashFlowService cashFlowService;
    @Resource
    private RiskRecordService riskRecordService;
    @Resource
    private UserEquipmentService userEquipmentService;
    @Resource
    private ChannelService channelService;
    @Resource
    private BizIntegrationService bizIntegrationService;
    @Resource
    private UserParamCheckService userParamCheckService;
    @Resource
    private UserEquipmentMapper userEquipmentMapper;

    @Override
    public Json<LoginMeta> doLogin(LoginInfo loginInfo, BasicParam basicParam) {
        Message message;
        if (this.appVersionIntegrationService.inWhiteList(loginInfo.getLoginName()).booleanValue()) {
            loginInfo.setCode("123456");
        }
        if (!this.userParamCheckService.checkParam(loginInfo)) {
            this.logger.info("doLogin failed:" + loginInfo);
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u53c2\u6570\u9519\u8bef");
        }
        UserAuth userAuth = this.userAuthMapper.selectByUserAuth(loginInfo.getType(), loginInfo.getLoginName());
        if (1 != loginInfo.getType() && null == userAuth) {
            if (this.appVersionIntegrationService.getPublishState(basicParam).booleanValue()) {
                LoginMeta meta = new LoginMeta();
                meta.setCode(512);
                return ResultUtil.genSuccessResult((Object)meta);
            }
            return this.registerAndBindingPhone(loginInfo, null, basicParam);
        }
        if (this.userParamCheckService.checkVerifyPwd(loginInfo) && !(message = this.userParamCheckService.verifyPwd(loginInfo.getPassword(), userAuth)).isSuccess()) {
            return ResultUtil.genFailedResult((String)message.getLastMessage());
        }
        LoginMeta meta = this.updateUserAfterLogin(userAuth, loginInfo, basicParam);
        if (meta.getUser() != null) {
            this.bizLogIntegrationService.login(meta.getUser().getId(), Integer.valueOf(basicParam.getPlatform()));
        }
        return ResultUtil.genSuccessResult((Object)meta);
    }

    private LoginMeta updateUserAfterLogin(UserAuth userAuth, LoginInfo loginInfo, BasicParam basicParam) {
        Message deviceExistMessage = this.userLoginHistoryService.isDeviceExist(userAuth.getUserId(), basicParam.getDevcId());
        User user = this.userMapper.selectByPrimaryKey(userAuth.getUserId());
        this.updateWechat(loginInfo, user, basicParam.getPlatform());
        this.callAsyncUpdateLocation(loginInfo, user);
        String equipment = deviceExistMessage.getParamMap().get("equipment") == null ? null : deviceExistMessage.getParamMap().get("equipment").toString();
        UserInfoDTO dto = this.getUpdateUser(loginInfo, user, basicParam, equipment);
        LoginMeta meta = new LoginMeta(dto, !deviceExistMessage.isSuccess());
        if (!deviceExistMessage.isSuccess()) {
            this.saveNewUserCache(userAuth.getUserId());
            if (loginInfo.getType() == 3) {
                this.logger.info("\u7528\u6237\u7b2c\u4e00\u6b21\u5fae\u4fe1\u6388\u6743\u767b\u9646-----\u7ed1\u5b9aVIP\u9080\u8bf7\u5173\u7cfb");
                this.dealVipActivation(user.getId(), loginInfo.getLoginName(), basicParam.getPlatform());
                this.userNewsIntegrationService.initUserNewsImage(user.getId(), null);
            }
        }
        this.redisHashMapAdapter.put(RedisConfig.USER_INFO, userAuth.getUserId().toString(), (Object)JSON.toJSONString((Object)meta.getUser()));
        return meta;
    }

    private UserInfoDTO getUpdateUser(LoginInfo loginInfo, User user, BasicParam basicParam, String equipment) {
        user.setToken(JwtTokenUtil.generateToken((Long)user.getId()));
        user.setExpiretime(Long.valueOf(JwtTokenUtil.generateExpirationDate().getTime()));
        user.setRefreshtoken(user.getRefreshtoken());
        user.setEquipment(equipment);
        user.setLastLoginIp(loginInfo.getLastLoginIp());
        if (user.getChannelId() == 0L) {
            user.setChannelId(this.channelService.getChannelByCode(basicParam.getChnl()).getId());
        }
        this.logger.debug("\u7528\u6237[{}]\u5bf9\u5e94\u7684\u72b6\u6001\uff1a[{}]", (Object)user.getId(), (Object)user.getState());
        this.logger.debug("\u7528\u6237\u72b6\u6001\u662f\u5426\u5904\u4e8e\u672a\u6fc0\u6d3b\u72b6\u6001\uff1a[{}]", (Object)(2 == user.getState() ? 1 : 0));
        if (2 == user.getState()) {
            UserAccount userAccount = this.userAccountService.getUserAccountDetail(user.getId());
            user.setState(Byte.valueOf((byte)1));
            boolean isEquipmentExist = true;
            if (null != equipment) {
                isEquipmentExist = this.userEquipmentMapper.countEquipment(equipment, "DRAW") > 0;
            }
            BigDecimal cash = this.cashFlowService.getMySelfBounty(userAccount.getUserId());
            if (isEquipmentExist) {
                Long relationId = this.updateInviteStatus(user, false);
                this.updateUserCashState(userAccount, relationId, false, cash);
            } else {
                Long relationId = this.updateInviteStatus(user, true);
                this.updateUserCashState(userAccount, relationId, true, cash);
                if (cash.compareTo(BigDecimal.ZERO) > 0) {
                    UserEquipment userEquipment = new UserEquipment(Long.valueOf(this.nextId()), equipment, "DRAW");
                    this.userEquipmentService.addUserEquipment(userEquipment);
                }
            }
            this.quartzManageIntegrationService.removeInviteTask(user.getInviteUserId() + "_" + user.getId());
            Integer platform = basicParam.getPlatform() == 0 ? Integer.parseInt(user.getRegisterClient()) : basicParam.getPlatform();
            this.bizLogIntegrationService.newUser(user.getId(), basicParam.getChnl(), user.getToken(), userAccount.getTotalCash(), StringUtils.isNotEmpty((CharSequence)user.getRegisterChannel()) ? user.getRegisterChannel() : "0", null == user.getRelationId() ? null : user.getRelationId().toString(), platform);
        }
        this.userMapper.updateByPrimaryKeySelective(user);
        return this.userService.convertUserToDTO(user);
    }

    private Long updateInviteStatus(User user, boolean isEffective) {
        if (null == user.getInviteUserId()) {
            return null;
        }
        InviteRecord inviteRecord = this.inviteRecordService.getInviteRecordByInvitedUser(user.getInviteUserId(), user.getId());
        if (null == inviteRecord) {
            return null;
        }
        this.updateInviteUserState(inviteRecord, isEffective);
        if (isEffective) {
            this.bizLogIntegrationService.inviteSuccessed(inviteRecord.getUserId(), user.getId(), null == user.getRegisterClient() ? null : Integer.valueOf(user.getRegisterClient()));
        }
        return inviteRecord.getId();
    }

    private void updateUserCashState(UserAccount userAccount, Long relationId, boolean isEffective, BigDecimal cash) {
        this.logger.debug("\u65b0\u7528\u6237[{}]\u9996\u6b21\u767b\u9646\u4e34\u65f6\u8d4f\u91d1[{}]\u8f6c\u6362\u4e3a\u53ef\u63d0\u73b0\u8d4f\u91d1", (Object)userAccount.getUserId(), (Object)cash);
        if (cash.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        if (isEffective) {
            AccountCashParam param = new AccountCashParam(userAccount.getUserId(), CashEnum.TEMP_CASH.name(), Boolean.valueOf(false), cash, relationId, null, CashFlowConvertTypeEnum.TEMP_TO_DRAWABLE.name());
            this.userAccountService.transferCash(param);
        } else {
            AccountCashParam accountCashParam = new AccountCashParam();
            accountCashParam.setUserId(userAccount.getUserId());
            accountCashParam.setCashType(CashEnum.TEMP_CASH.name());
            accountCashParam.setAddTotal(Boolean.valueOf(false));
            accountCashParam.setCashFlowType(CashFlowTypeEnum.INVALID_PACKET.name());
            accountCashParam.setCash(cash.negate());
            accountCashParam.setRelationId(relationId);
            this.userAccountService.addCash(accountCashParam);
        }
    }

    private void updateInviteUserState(InviteRecord inviteRecord, boolean isEffective) {
        if (inviteRecord == null) {
            return;
        }
        if (!InviteRecordStateEnum.ACCEPT_INVITE.name().equals(inviteRecord.getInviteState())) {
            this.logger.info("\u5f53\u524d\u9080\u8bf7\u4eba[{}]\u4e0e\u53d7\u9080\u4eba[{}]\u7684\u72b6\u6001\u5904\u4e8e[{}]------\u4e0d\u4e88\u5904\u7406", new Object[]{inviteRecord.getUserId(), inviteRecord.getInvitedUserId(), inviteRecord.getInviteState()});
        }
        if (isEffective) {
            AccountCashParam param = new AccountCashParam(inviteRecord.getUserId(), CashEnum.STABILIZE_CASH.name(), Boolean.valueOf(false), inviteRecord.getAward(), inviteRecord.getId(), CashFlowTypeEnum.PROMOTE_BOUNTY.name(), CashFlowConvertTypeEnum.TEMP_TO_STABILIZE.name());
            this.userAccountService.transferCash(param);
            inviteRecord.setInviteState(InviteRecordStateEnum.LOGIN_APP.getName());
            inviteRecord.setEffectTime(null);
            inviteRecord.setAwardType(AwardTypeEnum.CASH.name());
            this.inviteRecordService.updateInviteRecord(inviteRecord);
        } else {
            AccountCashParam accountCashParam = new AccountCashParam();
            accountCashParam.setUserId(inviteRecord.getUserId());
            accountCashParam.setCashType(CashEnum.TEMP_CASH.name());
            accountCashParam.setAddTotal(Boolean.valueOf(false));
            accountCashParam.setCashFlowType(CashFlowTypeEnum.INVALID_BOUNTY.name());
            accountCashParam.setCash(inviteRecord.getAward().negate());
            accountCashParam.setRelationId(inviteRecord.getId());
            this.userAccountService.addCash(accountCashParam);
            inviteRecord.setInviteState(InviteRecordStateEnum.OVERDUE_INVALID.name());
            inviteRecord.setAwardType(AwardTypeEnum.CASH.name());
            inviteRecord.setStatus(Byte.valueOf((byte)0));
            this.inviteRecordService.updateInviteRecord(inviteRecord);
        }
    }

    private void updateWechat(LoginInfo loginInfo, User user, int platform) {
        this.logger.debug("\u7528\u6237\u767b\u9646\u4f20\u5165\u7684\u53c2\u6570\uff1a[{}]", (Object)JSON.toJSONString((Object)loginInfo));
        if (3 == loginInfo.getType()) {
            loginInfo.setUnionId(loginInfo.getLoginName());
        }
        if (null != loginInfo.getOpenId() && null != loginInfo.getUnionId()) {
            UserAuth userAuth = this.userAuthMapper.selectByUserId(Byte.valueOf((byte)3), user.getId());
            if (userAuth == null) {
                this.logger.debug("\u5f53\u524d\u7528\u6237\u521b\u5efaunionId\u9274\u6743\u4fe1\u606f:\u7528\u6237id\uff1a[{}], unionId:[{}]", (Object)user.getId(), (Object)loginInfo.getUnionId());
                Message isBindedMsg = this.userAuthService.checkBindExist((byte)3, loginInfo.getUnionId());
                if (isBindedMsg.isSuccess()) {
                    user.setWeixin(loginInfo.getUnionId());
                    this.userAuthService.addUserAuth((byte)3, user.getId(), loginInfo.getUnionId(), null);
                    if (null != loginInfo.getNickname()) {
                        user.setNickname(user.getNickname() == null ? loginInfo.getNickname() : user.getNickname());
                    }
                    if (null != loginInfo.getHeadImg()) {
                        user.setHeadImg(user.getHeadImg() == null ? loginInfo.getHeadImg() : user.getHeadImg());
                    }
                    this.userSyncService.sync(user);
                }
            }
            if ((userAuth = this.userAuthMapper.selectByUserAuth(Byte.valueOf((byte)6), loginInfo.getOpenId())) == null) {
                this.logger.debug("\u5f53\u524d\u7528\u6237\u521b\u5efaAPP\u5fae\u4fe1\u6388\u6743\u767b\u9646openId\u9274\u6743\u4fe1\u606f:\u7528\u6237id\uff1a[{}], openId:[{}]", (Object)user.getId(), (Object)loginInfo.getOpenId());
                this.userAuthService.addUserAuth((byte)6, user.getId(), loginInfo.getOpenId(), null);
            }
        }
    }

    private void callAsyncUpdateLocation(LoginInfo loginInfo, User user) {
        LoginService loginService = (LoginService)SpringContextHolder.getBean(LoginService.class);
        loginService.updateLocation(loginInfo, user);
    }

    @Override
    @Async
    public void updateLocation(LoginInfo loginInfo, User user) {
        User originalUser;
        if (null != loginInfo.getId() && null != (originalUser = this.userMapper.selectByPrimaryKey(loginInfo.getId())) && null != originalUser.getLocationCode() && null != originalUser.getLocationName()) {
            user.setLocationCode(originalUser.getLocationCode());
            user.setLocationName(originalUser.getLocationName());
        }
    }

    private void copyUserInfo(LoginInfo loginInfo, User user) {
        if (loginInfo.getId() == null || loginInfo.getId() == 0L) {
            this.logger.warn(LogMarker.BIZ, "\u7528\u6237\u6ce8\u518c\uff0c\u4f46\u662f\u6ca1\u6709\u63d0\u4f9b\u9759\u9ed8\u6ce8\u518cID[H5\u7ad9\u5916\u6ce8\u518c\u4f8b\u5916]\uff0cloginInfo:[{}],user:[{}]", (Object)loginInfo, (Object)user);
            this.userNewsIntegrationService.initUserNewsImage(user.getId(), null);
        } else {
            this.logger.debug(LogMarker.BIZ, "\u7528\u6237\u6ce8\u518c,\u4ece\u8bbf\u5ba2\u8d26\u53f7\u62f7\u8d1d\u6807\u7b7e\u6743\u91cd\u4fe1\u606f\u548c\u9891\u9053\u5217\u8868\uff0cloginInfo:[{}],user:[{}]", (Object)loginInfo, (Object)user);
            this.userNewsIntegrationService.initUserNewsImage(user.getId(), loginInfo.getId());
        }
    }

    @Override
    public Json<LoginMeta> registerAndBindingPhone(LoginInfo loginInfo, Long userId, BasicParam basicParam) {
        if (!this.userParamCheckService.bandingAndRegisterCheckParam(loginInfo)) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u53c2\u6570\u9519\u8bef");
        }
        Message messageByCheckAuth = this.userAuthService.checkBindExist(loginInfo.getType(), loginInfo.getLoginName());
        if (!messageByCheckAuth.isSuccess()) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)messageByCheckAuth.getLastMessage());
        }
        User user = this.getUserByType(loginInfo);
        Message messageByCheckUser = this.userParamCheckService.checkRepeatBind(user, loginInfo);
        if (!messageByCheckUser.isSuccess()) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)messageByCheckUser.getLastMessage());
        }
        if (null != userId && null != (user = this.userMapper.selectByPrimaryKey(userId)) && 0 == user.getState()) {
            user = null;
        }
        if (1 == loginInfo.getType() && StringUtils.isNotBlank((CharSequence)loginInfo.getCode()) && !this.smsIntegrationService.verifySmsCodeByType(Byte.valueOf((byte)2), loginInfo.getPhone(), loginInfo.getCode()).booleanValue()) {
            return ResultUtil.genFailedResult((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u9a8c\u8bc1\u7801");
        }
        LoginMeta meta = this.binding(user, loginInfo, basicParam);
        return ResultUtil.genSuccessResult((Object)meta);
    }

    private User getUserByType(LoginInfo loginInfo) {
        User user = null;
        if (3 == loginInfo.getType()) {
            user = this.userMapper.findByWeixin(loginInfo.getLoginName());
        } else if (1 == loginInfo.getType()) {
            user = this.userMapper.findByPhone(loginInfo.getPhone());
        }
        return user;
    }

    private LoginMeta binding(User user, LoginInfo loginInfo, BasicParam basicParam) {
        UserInfoDTO dto;
        LoginMeta meta = new LoginMeta();
        if (null != user) {
            this.syncThirdPartyInfo(user, loginInfo);
            this.updateTokenAfterBinding(user, loginInfo, basicParam);
            this.addUserAuth(loginInfo, user.getId());
            dto = this.userService.convertUserToDTO(user);
        } else {
            DefaultUserWarper warper = this.addDefaultUser(loginInfo, basicParam);
            user = warper.user;
            dto = warper.dto;
        }
        boolean isFirstLogin = false;
        EquipmentDTO equipmentDTO = this.bizIntegrationService.getDevice(basicParam.getDevcId());
        Message deviceExistMessage = this.userLoginHistoryService.isDeviceExistByDeviceId(user.getId(), equipmentDTO == null ? null : equipmentDTO.getId());
        if (!deviceExistMessage.isSuccess()) {
            isFirstLogin = true;
        }
        if (isFirstLogin) {
            this.saveNewUserCache(user.getId());
            if (loginInfo.getType() == 3) {
                this.logger.info("\u7528\u6237\u7b2c\u4e00\u6b21\u5fae\u4fe1\u6388\u6743\u767b\u9646-----\u7ed1\u5b9aVIP\u9080\u8bf7\u5173\u7cfb");
                this.dealVipActivation(user.getId(), loginInfo.getLoginName(), basicParam.getPlatform());
            }
        }
        this.logger.info("\u7528\u6237\u5728\u6ce8\u518c\u767b\u5f55\u540e\u5b58\u5165redis,\u5b9e\u4f53:{}", (Object)JSON.toJSONString((Object)dto));
        this.redisHashMapAdapter.put(RedisConfig.USER_INFO, user.getId().toString(), (Object)JSON.toJSONString((Object)dto));
        this.userService.checkCompleteInfo(dto);
        meta.setUser(dto);
        meta.setFirstLogin(isFirstLogin);
        return meta;
    }

    private void saveNewUserCache(Long id) {
        KeyGenerator key = RedisConfig.NEW_USER_LOGIN.copy().appendKey((Object)id);
        this.redisStringAdapter.set(key, (Object)true);
        this.redisStringAdapter.expire(key, (long)DateUtils.getCurSeconds());
    }

    private void updateTokenAfterBinding(User user, LoginInfo loginInfo, BasicParam basicParam) {
        user.setToken(JwtTokenUtil.generateToken((Long)user.getId()));
        user.setExpiretime(Long.valueOf(JwtTokenUtil.generateExpirationDate().getTime()));
        if (loginInfo.getSex() != null) {
            user.setSex(loginInfo.getSex());
        }
        user.setLastLoginTime(new Date());
        this.userMapper.updateByPrimaryKeySelective(user);
        if (StringUtils.isNotEmpty((CharSequence)user.getPhone()) && user.getPhone().startsWith("170") || user.getPhone().startsWith("171")) {
            this.userMapper.updateUserToRisk(user.getId());
        } else if (this.checkRisk(user, loginInfo, basicParam).booleanValue()) {
            this.userMapper.updateUserToRisk(user.getId());
        }
    }

    private Boolean checkRisk(User user, LoginInfo loginInfo, BasicParam basicParam) {
        String operateSource = "";
        if (basicParam.getPlatform() == 1) {
            operateSource = "ANDROID";
        } else if (basicParam.getPlatform() == 2) {
            operateSource = "IOS";
        }
        RiskParam riskParam = new RiskParam();
        riskParam.setDeviceToken(loginInfo.getDeviceToken());
        riskParam.setIp(loginInfo.getRegIp());
        riskParam.setOperateSource(operateSource);
        riskParam.setPhone(user.getPhone());
        EquipmentDTO equipmentDTO = this.bizIntegrationService.getDevice(basicParam.getDevcId());
        if (null != equipmentDTO && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{equipmentDTO.getId()})) {
            riskParam.setEquiment(equipmentDTO.getId());
            riskParam.setOperateSystem(equipmentDTO.getPhoneModel());
        }
        return this.riskRecordService.checkRiskDevice(riskParam);
    }

    private DefaultUserWarper addDefaultUser(LoginInfo loginInfo, BasicParam basicParam) {
        User user = this.userService.addUser(loginInfo, basicParam, (byte)1);
        UserInfoDTO dto = this.userService.convertUserToDTO(user);
        dto.setCreateTime(new Date());
        this.copyUserInfo(loginInfo, user);
        if (null != loginInfo.getInviteCode()) {
            this.inviteRelationIntegrationService.addInviteRelation(user.getId(), loginInfo.getInviteCode());
        }
        return new DefaultUserWarper(user, dto);
    }

    private void dealVipActivation(Long userId, String wechat, Integer platform) {
        this.vipIntegrationService.saveVipViewRecord(userId, wechat, platform);
    }

    private void addUserAuth(LoginInfo loginInfo, Long userId) {
        this.logger.info("\u6dfb\u52a0\u7528\u6237\u6743\u9650\u8ba4\u8bc1");
        UserAuth auth = new UserAuth();
        auth.setUserId(userId);
        auth.setType(loginInfo.getType());
        if (StringUtils.equals((CharSequence)loginInfo.getPhone(), (CharSequence)loginInfo.getLoginName())) {
            auth.setIdentifier(loginInfo.getPhone());
            if (StringUtils.isNotEmpty((CharSequence)loginInfo.getPassword())) {
                auth.setCredential(MD5Util.hgmd5((String)loginInfo.getPassword()));
            }
            this.userAuthMapper.insertSelective(auth);
        }
        if (StringUtils.notEquals((CharSequence)loginInfo.getPhone(), (CharSequence)loginInfo.getLoginName())) {
            auth.setIdentifier(loginInfo.getLoginName());
            this.userAuthMapper.insertSelective(auth);
        }
    }

    private void syncThirdPartyInfo(User user, LoginInfo loginInfo) {
        if (1 == loginInfo.getType()) {
            user.setPhone(loginInfo.getLoginName());
        } else if (2 == loginInfo.getType()) {
            user.setQq(loginInfo.getLoginName());
        } else if (4 == loginInfo.getType()) {
            user.setWeibo(loginInfo.getLoginName());
        } else if (3 == loginInfo.getType()) {
            user.setWeixin(loginInfo.getLoginName());
            if (null != loginInfo.getNickname()) {
                user.setNickname(user.getNickname() == null ? loginInfo.getNickname() : user.getNickname());
            }
            if (null != loginInfo.getHeadImg()) {
                user.setHeadImg(user.getHeadImg() == null ? loginInfo.getHeadImg() : user.getHeadImg());
            }
        }
    }

    private class DefaultUserWarper {
        User user;
        UserInfoDTO dto;

        DefaultUserWarper(User user, UserInfoDTO dto) {
            this.user = user;
            this.dto = dto;
        }
    }
}

