/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.user.domain.UserAuthMapper;
import com.bxm.localnews.user.integration.BizLogIntegrationService;
import com.bxm.localnews.user.service.UserAuthService;
import com.bxm.localnews.user.service.UserService;
import com.bxm.localnews.user.vo.LoginInfo;
import com.bxm.localnews.user.vo.UserAuth;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="userAuthService")
public class UserAuthServiceImpl
implements UserAuthService {
    private static final Logger log = LoggerFactory.getLogger(UserAuthServiceImpl.class);
    @Resource
    private UserAuthMapper userAuthMapper;
    @Resource
    private UserService userService;
    @Resource
    private BizLogIntegrationService bizLogIntegrationService;

    @Override
    public int addUserAuth(Byte type, Long userId, String identifier, String credential) {
        UserAuth auth = this.generateUserAuth(userId, type, identifier, credential);
        return this.userAuthMapper.insertSelective(auth);
    }

    @Override
    public UserAuth selectByUserAuth(Byte type, String openId) {
        log.info("\u6839\u636e\u767b\u9646\u7c7b\u578b[{}]\u67e5\u8be2openId[{}]\u7684\u76f8\u5173\u4fe1\u606f", (Object)type, (Object)openId);
        if (8 == type) {
            UserAuth userAuth = this.userAuthMapper.selectByUserAuth(type, openId);
            if (userAuth != null) {
                return userAuth;
            }
            log.info("\u5f53\u524d\u767b\u9646\u7c7b\u578b\u662f\u3010\u4e07\u4e8b\u901a\u5c0f\u7a0b\u5e8f\u3011--------\u521b\u5efa\u9759\u9ed8\u7528\u6237");
            Long userId = this.userService.addWSTAppletUser();
            UserAuth auth = this.generateUserAuth(userId, type, openId, null);
            this.userAuthMapper.insertSelective(auth);
            log.info("\u521b\u5efa\u9759\u9ed8\u7528\u6237\u6210\u529f\uff1a[{}]", (Object)JSON.toJSONString((Object)auth));
            this.bizLogIntegrationService.newUser(userId, "wxapp", openId, BigDecimal.ZERO, "MINI_WST", null, Integer.valueOf(5));
            return auth;
        }
        return this.userAuthMapper.selectByUserAuth(type, openId);
    }

    @Override
    public UserAuth selectByUserAuth(Long userId, Byte type) {
        return this.userAuthMapper.selectByUserId(type, userId);
    }

    @Override
    public Message addUserAuthByWeixin(Long userId, String unionId, String openId) {
        UserAuth auth = this.generateUserAuth(userId, (byte)3, unionId, null);
        this.userAuthMapper.insertSelective(auth);
        auth = this.generateUserAuth(userId, (byte)5, openId, null);
        this.userAuthMapper.insertSelective(auth);
        return Message.build();
    }

    @Override
    public void saveAuth(Long userId, LoginInfo loginInfo) {
        ArrayList<UserAuth> authList = new ArrayList<UserAuth>();
        UserAuth auth = new UserAuth();
        auth.setUserId(userId);
        auth.setType(loginInfo.getType());
        auth.setIdentifier(loginInfo.getLoginName());
        if (StringUtils.isNotBlank((CharSequence)loginInfo.getPassword())) {
            auth.setCredential(MD5Util.hgmd5((String)loginInfo.getPassword()));
        }
        authList.add(auth);
        log.warn("\u6dfb\u52a0\u6743\u9650\u9a8c\u8bc1:{}", (Object)loginInfo.getLoginName());
        if (1 != loginInfo.getType()) {
            if (null != loginInfo.getPhone()) {
                UserAuth phoneAuth = new UserAuth();
                phoneAuth.setUserId(userId);
                phoneAuth.setType(Byte.valueOf((byte)1));
                phoneAuth.setIdentifier(loginInfo.getPhone());
                if (StringUtils.isNotBlank((CharSequence)loginInfo.getPassword())) {
                    phoneAuth.setCredential(MD5Util.hgmd5((String)loginInfo.getPassword()));
                }
                authList.add(phoneAuth);
            }
            if (loginInfo.getOpenId() != null) {
                UserAuth openIdAuth = new UserAuth();
                openIdAuth.setUserId(userId);
                openIdAuth.setType(Byte.valueOf((byte)6));
                openIdAuth.setIdentifier(loginInfo.getOpenId());
                if (StringUtils.isNotBlank((CharSequence)loginInfo.getPassword())) {
                    openIdAuth.setCredential(MD5Util.hgmd5((String)loginInfo.getPassword()));
                }
                authList.add(openIdAuth);
            }
        }
        this.userAuthMapper.batchAdd(authList);
    }

    @Override
    public Message checkBindExist(Byte loginType, String loginName) {
        UserAuth auth = this.userAuthMapper.selectByUserAuth(loginType, loginName);
        if (null != auth) {
            if (1 == loginType) {
                return Message.build((boolean)false, (String)"\u624b\u673a\u53f7\u5df2\u88ab\u7ed1\u5b9a");
            }
            if (3 == loginType) {
                return Message.build((boolean)false, (String)"\u5fae\u4fe1\u53f7\u5df2\u88ab\u7ed1\u5b9a");
            }
            if (4 == loginType) {
                return Message.build((boolean)false, (String)"\u5fae\u535a\u5df2\u88ab\u7ed1\u5b9a");
            }
            if (2 == loginType) {
                return Message.build((boolean)false, (String)"QQ\u53f7\u5df2\u88ab\u7ed1\u5b9a");
            }
        }
        return Message.build((boolean)true);
    }

    private UserAuth generateUserAuth(Long userId, Byte type, String identifier, String credential) {
        UserAuth auth = new UserAuth();
        auth.setUserId(userId);
        auth.setType(type);
        auth.setIdentifier(identifier);
        auth.setCredential(credential);
        return auth;
    }
}

