/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.service.impl;

import com.bxm.localnews.user.domain.UserEquipmentMapper;
import com.bxm.localnews.user.dto.EquipmentDTO;
import com.bxm.localnews.user.integration.BizIntegrationService;
import com.bxm.localnews.user.service.UserEquipmentService;
import com.bxm.localnews.user.vo.UserEquipment;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserEquipmentServiceImpl
implements UserEquipmentService {
    @Resource
    private UserEquipmentMapper userEquipmentMapper;
    @Autowired
    private BizIntegrationService bizIntegrationService;

    @Override
    public UserEquipment selectByEquipment(String equipment) {
        return this.userEquipmentMapper.selectByEquipment(equipment);
    }

    @Override
    public Message addUserEquipment(UserEquipment userEquipment) {
        this.userEquipmentMapper.addEquipment(userEquipment);
        return Message.build();
    }

    @Override
    public Message checkExistEquipment(String equipment, String activityType) {
        EquipmentDTO equipmentDTO = this.bizIntegrationService.getDevice(equipment);
        if (null != equipmentDTO && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{equipmentDTO.getId()})) {
            boolean isEquipmentExist = this.userEquipmentMapper.countEquipment(equipmentDTO.getId(), activityType) > 0;
            return Message.build((boolean)isEquipmentExist).addParam("id", (Object)equipmentDTO.getId());
        }
        return Message.build((boolean)true);
    }
}

