/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.service.impl;

import com.bxm.localnews.user.domain.UserLoginHistoryMapper;
import com.bxm.localnews.user.dto.EquipmentDTO;
import com.bxm.localnews.user.integration.BizIntegrationService;
import com.bxm.localnews.user.service.UserLoginHistoryService;
import com.bxm.localnews.user.vo.UserLoginHistory;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.Message;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UserLoginHistoryServiceImpl
extends BaseService
implements UserLoginHistoryService {
    @Resource
    private UserLoginHistoryMapper userLoginHistoryMapper;
    @Resource
    private BizIntegrationService bizIntegrationService;

    @Override
    @Async
    public void save(UserLoginHistory userLoginHistory) {
        this.userLoginHistoryMapper.insertSelective(userLoginHistory);
    }

    @Override
    public Message isDeviceExist(Long userId, String deviceId) {
        EquipmentDTO equipmentDTO = this.bizIntegrationService.getDevice(deviceId);
        if (null != equipmentDTO) {
            List userLoginHistoryList = this.userLoginHistoryMapper.selectUserByEquipment(userId, deviceId);
            if (CollectionUtils.isEmpty((Collection)userLoginHistoryList)) {
                return Message.build((boolean)false).addParam("equipment", (Object)equipmentDTO.getId());
            }
            return Message.build((boolean)true).addParam("equipment", (Object)equipmentDTO.getId());
        }
        return Message.build((boolean)true);
    }

    @Override
    public Message isDeviceExistByDeviceId(Long userId, String deviceId) {
        if (null == userId || StringUtils.isEmpty((Object)deviceId)) {
            return Message.build((boolean)true);
        }
        List userLoginHistoryList = this.userLoginHistoryMapper.selectUserByEquipment(userId, deviceId);
        return Message.build((boolean)CollectionUtils.isEmpty((Collection)userLoginHistoryList));
    }
}

