package com.bxm.localnews.user.config;

import java.math.BigDecimal;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties("user.config")
public class UserProperties {

    /**
     * 微信信息同步超时时间
     */
    private long wechatSyncTimeout;

    /**
     * 金币流水记录开关
     */
    private boolean flowSwitch;

    /**
     * 用户默认头像
     */
    private String defaultHeadImgUrl;

    /**
     * 用户生成token时的appKey
     */
    private String appKey;

    /**
     * 金币兑换率
     */
    private BigDecimal goldRate = BigDecimal.valueOf(1000);

    /**
     * 当天限制提现金额
     */
    private BigDecimal todayLimitBalance = BigDecimal.valueOf(10);

    /**
     * 每笔提现最低金额
     */
    private BigDecimal mixWithdrawBalance = BigDecimal.valueOf(0.3);

    /**
     * 每笔提现最大金额
     */
    private BigDecimal maxWithdrawBalance = BigDecimal.valueOf(10);

    /**
     * 新用户邀请奖励 500朵小红花
     */
    private Integer newUserGold = 500;

    /**
     * 老用户邀请奖励3朵小红花
     */
    private Integer oldUserGold = 3;

    /**
     * 线下推广赏金
     */
    private BigDecimal bountyOffline;

    public String getDefaultHeadImgUrl() {
        return defaultHeadImgUrl;
    }

    public void setDefaultHeadImgUrl(String defaultHeadImgUrl) {
        this.defaultHeadImgUrl = defaultHeadImgUrl;
    }

    public boolean isFlowSwitch() {
        return flowSwitch;
    }

    public void setFlowSwitch(boolean flowSwitch) {
        this.flowSwitch = flowSwitch;
    }

    public long getWechatSyncTimeout() {
        return wechatSyncTimeout;
    }

    public void setWechatSyncTimeout(long wechatSyncTimeout) {
        this.wechatSyncTimeout = wechatSyncTimeout;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public BigDecimal getBountyOffline() {
        return bountyOffline;
    }

    public void setBountyOffline(BigDecimal bountyOffline) {
        this.bountyOffline = bountyOffline;
    }

    public BigDecimal getGoldRate() {
        return goldRate;
    }

    public void setGoldRate(BigDecimal goldRate) {
        this.goldRate = goldRate;
    }

    public BigDecimal getTodayLimitBalance() {
        return todayLimitBalance;
    }

    public void setTodayLimitBalance(BigDecimal todayLimitBalance) {
        this.todayLimitBalance = todayLimitBalance;
    }

    public BigDecimal getMixWithdrawBalance() {
        return mixWithdrawBalance;
    }

    public void setMixWithdrawBalance(BigDecimal mixWithdrawBalance) {
        this.mixWithdrawBalance = mixWithdrawBalance;
    }

    public BigDecimal getMaxWithdrawBalance() {
        return maxWithdrawBalance;
    }

    public void setMaxWithdrawBalance(BigDecimal maxWithdrawBalance) {
        this.maxWithdrawBalance = maxWithdrawBalance;
    }

    public Integer getNewUserGold() {
        return newUserGold;
    }

    public void setNewUserGold(Integer newUserGold) {
        this.newUserGold = newUserGold;
    }

    public Integer getOldUserGold() {
        return oldUserGold;
    }

    public void setOldUserGold(Integer oldUserGold) {
        this.oldUserGold = oldUserGold;
    }
}
