package com.bxm.localnews.user.saf;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.HashMap;

import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.saf.model.v20180919.ExecuteRequestRequest;
import com.aliyuncs.saf.model.v20180919.ExecuteRequestResponse;
import com.bxm.localnews.user.domain.RiskRecordMapper;
import com.bxm.localnews.user.param.RiskParam;
import com.bxm.localnews.user.vo.RiskRecord;
import com.bxm.newidea.component.tools.DateUtils;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpStatus;

/**
 * @author zhaoyadong 2019/3/21 14:50
 * @desc
 */
@Slf4j
public class IdentifyRiskSaf {

    private static final String acesskeyId = "LTAIfYrWiI3zpHqX";

    private static final String secretKey = "3Lmcjh6gWLraAgAlGlHiS2UpM4Vq2i";

    private static final String product = "saf";

    private static final String regionId = "cn-hangzhou";

    private static final String domain = ".aliyuncs.com";

    private static final String service = "account_abuse_pro";

    public static void main(String[] args) {
//        System.out.println(JSON.toJSONString(identifyRisk("17044117820", "", "61.130.182.194")));
//        System.out.println(JSON.toJSONString(identifyRisk("17044117803", "", "61.130.182.194")));
//        System.out.println(JSON.toJSONString(identifyRisk("16506420511", "", "61.130.182.194")));
//        System.out.println(JSON.toJSONString(identifyRisk("16506420884", "", "61.130.182.194")));
//        System.out.println(JSON.toJSONString(identifyRisk("17109375540", "", "61.130.182.194")));
    }

    private static IAcsClient getClient() {
        IClientProfile profile = DefaultProfile.getProfile(regionId,
                acesskeyId, secretKey);
        DefaultProfile.addEndpoint(regionId, product,
                getDomain());
        return new DefaultAcsClient(profile);
    }

    private static String getDomain() {
        return product + "." + regionId
                + domain;
    }

    private static ExecuteRequestRequest getRequest() {
        ExecuteRequestRequest executeRequestRequest = new ExecuteRequestRequest();
        executeRequestRequest.setMethod(com.aliyuncs.http.MethodType.POST);
        executeRequestRequest.setService(service);

        return executeRequestRequest;
    }

    /**
     * 绑定手机号识别风险
     *
     * @param mobile
     */
    public static ExecuteRequestResponse identifyRisk(String mobile, String deviceToken, String ip) {
        HashMap<String, Object> serviceParams = Maps.newHashMap();

        //手机号，国内11位，国外参照文档
        serviceParams.put("mobile", mobile);
        serviceParams.put("operateTime", DateUtils.getCurSeconds());
        serviceParams.put("deviceToken", deviceToken);
        serviceParams.put("ip", ip);
        ExecuteRequestRequest executeRequestRequest = getRequest();
        executeRequestRequest.setReadTimeout(12000);
        executeRequestRequest.setServiceParameters(JSONObject.toJSONString(serviceParams));
        try {
            executeRequestRequest.setHttpContent(JSONObject.toJSONString(serviceParams).getBytes("UTF-8"),
                    "UTF-8", FormatType.JSON);
            ExecuteRequestResponse httpResponse = getClient().getAcsResponse(executeRequestRequest);
            log.info("httpResponse:" + JSONObject.toJSONString(httpResponse));
            return httpResponse;
        } catch (UnsupportedEncodingException unsupportException) {
            log.error("风险识别：json数据转换失败");
        } catch (ClientException clientException) {
            log.error("连接阿里风险识别客户端失败");
        }
        return null;
    }

    /**
     * 添加设备风险信息
     *
     * @param riskParam
     * @param executeRequestResponse
     * @param isBlack
     */
    private void addRiskRecord(RiskParam riskParam, ExecuteRequestResponse executeRequestResponse, Boolean isBlack,
                               RiskRecordMapper mapper) {
        RiskRecord riskRecord = new RiskRecord();
        riskRecord.setId(riskParam.getId());
        riskRecord.setPhone(riskParam.getPhone());
        riskRecord.setDeviceToken(riskParam.getEquiment());
        riskRecord.setOperateSystem(riskParam.getOperateSystem());
        riskRecord.setOperateSource(riskParam.getOperateSource());
        riskRecord.setScore(executeRequestResponse.getData().getScore());
        riskRecord.setTags(executeRequestResponse.getData().getTags());
        riskRecord.setRemark(executeRequestResponse.getData().getExtend());
        riskRecord.setReqIp(riskParam.getIp());
        riskRecord.setBlack(isBlack ? (byte) 1 : 0);
        mapper.addRiskRecord(riskRecord);
    }

    /**
     * 是否是风险用户
     *
     * @param score
     * @return
     */
    private boolean isRisk(BigDecimal score) {
        return BigDecimal.valueOf(65L).compareTo(score) < 0;
    }

    public boolean checkRiskDevice(RiskParam riskParam, RiskRecordMapper mapper) {
        ExecuteRequestResponse executeRequestResponse = identifyRisk(riskParam.getPhone(),
                riskParam.getDeviceToken(), riskParam.getIp());
        if (null != executeRequestResponse && HttpStatus.SC_OK == executeRequestResponse.getCode()) {
            BigDecimal score = new BigDecimal(executeRequestResponse.getData().getScore());
            log.info("当前设备手机号[{}]风险系数为[{}]", riskParam.getPhone(), score);
            boolean isRisk = isRisk(score);
            addRiskRecord(riskParam, executeRequestResponse, isRisk, mapper);
            return isRisk;
        }
        log.info("当前设备手机号：[{}]，设备token:[{}], ip:[{}]没能够风险识别", riskParam.getPhone(),
                riskParam.getDeviceToken(), riskParam.getIp());
        return false;
    }
}
