package com.bxm.localnews.user.service;

import java.math.BigDecimal;

import com.bxm.localnews.user.param.DeductPointParam;
import com.bxm.localnews.user.param.StoreNeceParam;

/**
 * @author zhaoyadong 2019/3/14 20:50
 * @desc
 */
public interface AccountService {

    /**
     * 获取积分商城用户金币
     *
     * @param storeNeceParam
     * @return
     */
    BigDecimal selectGoldByUserId(StoreNeceParam storeNeceParam);

    /**
     * 扣除用户金币
     *
     * @param deductPointParam
     * @return
     */
    Boolean deductUserGold(DeductPointParam deductPointParam);

    /**
     * 确认扣除用户金币
     *
     * @param deductPointParam
     * @return
     */
    void deductConfirmUserGold(DeductPointParam deductPointParam);

    /**
     * 用户添加金币
     *
     * @param deductPointParam
     * @return
     */
    void addUserGold(DeductPointParam deductPointParam);

    /**
     * 获取用户金币余额
     *
     * @param userId 用户id
     * @return
     */
    BigDecimal selectUsableGoldByUserId(Long userId);
}
