package com.bxm.localnews.user.service;

import com.bxm.localnews.user.dto.CashFlowDTO;
import com.bxm.localnews.user.dto.UserDayCashDTO;
import com.bxm.localnews.user.param.CashFlowParam;
import com.bxm.localnews.user.vo.CashFlow;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author zhaoyadong 2019/3/5 22:12
 * @desc
 */
public interface CashFlowService {

    /**
     * 获取用户最近7天的每天收入信息
     *
     * @param userId
     * @return
     */
    List<UserDayCashDTO> getRecentSevenDayCashFlowByUser(Long userId);

    List<CashFlowDTO> getUserAllCashFlow(CashFlowParam cashFlowParam);

    int addCashFlow(CashFlow cashFlow);

    /**
     * 获取账户自己的赏金金额
     *
     * @param userId
     * @return
     */
    BigDecimal getMySelfBounty(Long userId);

    BigDecimal getMyRedPacket(Long userId);


    /**
     * 是否出现引导体现弹窗(判断用户是否在app外领取了新用户赏金,其他约束条件在客户端完成)
     * @param userId 用户id
     * @return
     */
    boolean enableWithdraw(Long userId);
}
