package com.bxm.localnews.user.service;

import java.math.BigDecimal;
import java.util.List;

import com.bxm.localnews.user.param.GoldFlowParam;
import com.bxm.localnews.user.vo.FlowDetail;
import com.bxm.localnews.user.vo.GoldFlow;

/**
 * @author zhaoyadong 2019/3/5 22:12
 * @desc
 */
public interface GoldFlowService {

    /**
     * 添加金币流水
     *
     * @param goldFlow
     * @return
     */
    int addGoldFlow(GoldFlow goldFlow);

    /**
     * 获取用户金币流水
     *
     * @param goldFlowParam
     * @return
     */
    List<GoldFlow> getUserGoldFlow(GoldFlowParam goldFlowParam);

    /**
     * 获取昨日的金币
     *
     * @param userId
     * @return
     */
    BigDecimal getYesterdayGold(Long userId);

    /**
     * 获取金币流水
     *
     * @param userId
     * @return
     */
    List<FlowDetail> listGoldFlow(Long userId);

    /**
     * 根据帖子id获取流水金币数
     *
     * @param postId
     * @param userId
     * @return
     */
    Integer countGoldByPostId(Long postId, Long userId);
}
