package com.bxm.localnews.user.service;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.vo.LoginInfo;
import com.bxm.localnews.user.vo.LoginMeta;
import com.bxm.localnews.user.vo.User;

/**
 * Created by mars on 2018/2/23.
 */
public interface LoginService {

    /**
     * 用户登录，包括账号密码、验证码、第三方登录
     *
     * @param loginInfo  登录信息
     * @param basicParam 登录来源平台
     */
    Json<LoginMeta> doLogin(LoginInfo loginInfo, BasicParam basicParam);

    /**
     * 注册用户并绑定用户号码
     *
     * @param loginInfo 登录信息
     * @param platform  平台
     * @param chnl      渠道
     * @return
     */
    Json<LoginMeta> registerAndBindingPhone(LoginInfo loginInfo, int platform, Long userId, String chnl);

    /**
     * 登录时跟随静默用户的地理位置
     *
     * @param loginInfo
     * @param user
     */
    void updateLocation(LoginInfo loginInfo, User user);
}
