package com.bxm.localnews.user.service;

import java.math.BigDecimal;

import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.dto.UserAccountDTO;
import com.bxm.localnews.user.dto.UserAccountDayCashDTO;
import com.bxm.localnews.user.dto.UserCashGoldDTO;
import com.bxm.localnews.user.enums.ExtraInviteStateEnum;
import com.bxm.localnews.user.param.AccountCashParam;
import com.bxm.localnews.user.param.AccountGoldParam;
import com.bxm.localnews.user.vo.UserAccount;
import com.bxm.localnews.user.vo.UserCashInfoVo;
import com.bxm.newidea.component.vo.Message;

/**
 * @author zhaoyadong 2019/3/5 22:13
 * @desc
 */
public interface UserAccountService {

    /**
     * 获取用户累计余额
     *
     * @param userId
     * @return
     */
    BigDecimal getUserTotalCash(Long userId);

    /**
     * 获取账户详细信息
     *
     * @param userId
     * @return
     */
    UserAccount getUserAccountDetail(Long userId);

    /**
     * 创建用户账户
     *
     * @param userId
     * @return
     */
    Message createUserAccount(Long userId);

    /**
     * 获取用户账户信息
     *
     * @param userId
     * @return
     */
    UserAccountDTO getUserAccount(Long userId);

    /**
     * 获取用户账户信息以及是否可体现弹窗
     *
     * @param userId 用户id
     * @return 用户账户信息
     */
    UserAccountDTO getUserAccountAndEnableWithdraw(Long userId);


    /**
     * 获取用户账户信息及其对应7天的收入
     *
     * @param userId
     * @return
     */
    UserAccountDayCashDTO getUserAccountAndDetail(Long userId);

    /**
     * 获取用户对应现金金额和金币
     *
     * @param userId
     * @return
     */
    UserCashGoldDTO getUserCashGold(Long userId);

    /**
     * 修改用户金额
     *
     * @param param
     * @return
     */
    Boolean addCash(AccountCashParam param);

    /**
     * 用户金额转化
     *
     * @param param
     * @return
     */
    Boolean transferCash(AccountCashParam param);

    /**
     * 获取账户可提现金额
     *
     * @param userId
     * @return
     */
    BigDecimal getUserDrawableCash(Long userId);

    /**
     * 更新账户提现相关信息
     *
     * @param userId 用户id
     * @param amount 提现金额
     * @param state  提现状态
     * @return
     */
    Message updateUserWithdrawInfo(Long userId, BigDecimal amount, Byte state);

    /**
     * 修改账户金币信息
     *
     * @param param
     * @return
     */
    Boolean addGold(AccountGoldParam param);

    /**
     * 获取用户可用的金币
     *
     * @param userId
     * @return
     */
    Integer getUserUsableGold(Long userId);

    /**
     * 用户提现弹窗上报
     *
     * @param userId
     */
    void userWithdrawPop(Long userId);

    /**
     * 小程序提现
     *
     * @param userId
     * @param openId
     * @param amount
     * @param devcId
     * @param ip
     * @return
     */
    Json<BigDecimal> userGoldWithdraw(Long userId, String openId, BigDecimal amount, String devcId, String ip);

    /**
     * 获取用户及邀请人已获得金额信息
     *
     * @param userId
     * @return
     */
    UserCashInfoVo getUserCashInfo(Long userId);

    /**
     * 更新邀请人金额
     *  @param userId 被邀请人id
     * @param currentStateEnum 当前操作状态：1 提现 2 第二天登录
     */
    void updateInviteUserCash(Long userId, ExtraInviteStateEnum currentStateEnum);

}
