package com.bxm.localnews.user.service;

import com.bxm.localnews.user.vo.LoginInfo;
import com.bxm.localnews.user.vo.UserAuth;
import com.bxm.newidea.component.vo.Message;

/**
 * Created by Administrator on 2018/2/28.
 */
public interface UserAuthService {

    /**
     * 添加三方登录绑定
     */
    int addUserAuth(Byte type, Long userId, String identifier, String credential);

    /**
     * 根据openId查看用户是否存在当前系统中
     *
     * @param type
     * @param openId
     * @return
     */
    UserAuth selectByUserAuth(Byte type, String openId);

    /**
     * 获取APP用户提现的openId
     *
     * @param userId
     * @param type
     * @return
     */
    UserAuth selectByUserAuth(Long userId, Byte type);

    /**
     * 添加用户鉴权信息
     *
     * @param userId
     * @param unionId
     * @param openId
     * @return
     */
    Message addUserAuthByWeixin(Long userId, String unionId, String openId);

    /**
     * 添加授权登录认证信息
     *
     * @param userId
     * @param loginInfo
     */
    void saveAuth(Long userId, LoginInfo loginInfo);

}
