package com.bxm.localnews.user.service;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.user.dto.LocationDTO;
import com.bxm.localnews.user.param.PushParam;

/**
 * 用户相关内部接口，不对外服务暴露
 */
public interface UserInternalService {

    /**
     * 用户进行定位，并存在历史定位表中，需要事务
     *
     * @param code
     * @param userId
     * @return
     */
    LocationDTO doPostingLocation(String code, Long userId, BasicParam basicParam);

    /**
     * 用途：用户在更换地区后的异步操作
     * 1.更新用户的用户位置信息
     * 2.日志埋点
     * 3.更新用户再redis的对象
     * 4.清空用户首页缓存
     * 5.新增用户定位历史表
     *
     * @param locationDTO
     * @param userId
     * @param code
     */
    void updateUserLocation(LocationDTO locationDTO, Long userId, String code,int platform);

    /**
     * 保存推送信息
     *
     * @param pushParam
     */
    void savePush(PushParam pushParam);

}
