package com.bxm.localnews.user.service;

import java.math.BigDecimal;

import com.bxm.localnews.user.dto.UserWithdrawDTO;
import com.bxm.localnews.user.dto.WithdrawDTO;
import com.bxm.localnews.user.vo.WithdrawFlow;

/**
 * @author zhaoyadong 2019/3/6 10:18
 * @desc
 */
public interface UserWithdrawService {

    /**
     * 获取用户最后一笔的提现订单信息
     *
     * @return
     */
    UserWithdrawDTO getUserRecentWithdrawInfo(Long userId);

    /**
     * 获取提现信息
     *
     * @param id
     * @return
     */
    WithdrawFlow getWithdrawFlowById(Long id);

    /**
     * 获取小程序用户对应类型的当天提现记录
     *
     * @param userId
     * @param openId
     * @param state
     * @return
     */
    BigDecimal getMiniAppUserWithdraw(Long userId, String openId, Byte state);

    /**
     * 获取用户可提现配置列表
     *
     * @param userId
     * @param drawableCash
     * @param withdrawCash
     * @return
     */
    WithdrawDTO getWithDrawList(Long userId, BigDecimal drawableCash, BigDecimal withdrawCash);
}
