package com.bxm.localnews.user.service.impl;

import java.math.BigDecimal;
import java.util.List;

import com.bxm.localnews.user.domain.GoldFlowMapper;
import com.bxm.localnews.user.param.GoldFlowParam;
import com.bxm.localnews.user.service.GoldFlowService;
import com.bxm.localnews.user.vo.FlowDetail;
import com.bxm.localnews.user.vo.GoldFlow;

import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @author zhaoyadong 2019/3/5 22:14
 * @desc
 */
@Service
public class GoldFlowServiceImpl implements GoldFlowService {

    @Resource
    private GoldFlowMapper goldFlowMapper;

    @Override
    public int addGoldFlow(GoldFlow goldFlow) {
        return goldFlowMapper.addGoldFlow(goldFlow);
    }

    @Override
    public List<GoldFlow> getUserGoldFlow(GoldFlowParam goldFlowParam) {
        return this.goldFlowMapper.queryGoldFlows(goldFlowParam);
    }

    @Override
    public BigDecimal getYesterdayGold(Long userId) {
        return this.goldFlowMapper.getYesterdayGold(userId);
    }

    @Override
    public List<FlowDetail> listGoldFlow(Long userId) {
        return this.goldFlowMapper.listGoldFlow(userId);
    }

    @Override
    public Integer countGoldByPostId(Long postId, Long userId) {
        return this.goldFlowMapper.countGoldByPostId(postId, userId);
    }
}
