package com.bxm.localnews.user.service.impl;

import java.math.BigDecimal;
import java.util.List;

import javax.annotation.Resource;

import com.bxm.localnews.user.config.UserProperties;
import com.bxm.localnews.user.domain.PayFlowMapper;
import com.bxm.localnews.user.domain.UserAmountMapper;
import com.bxm.localnews.user.enums.TaskEnum;
import com.bxm.localnews.user.service.PayFlowService;
import com.bxm.localnews.user.service.UserRewardStatService;
import com.bxm.localnews.user.vo.FlowDetail;
import com.bxm.localnews.user.vo.PayFlow;
import com.bxm.newidea.component.service.BaseService;

import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

import static com.bxm.localnews.user.enums.AppConst.REWARD_TYPE_GOLD;

@Service
@RefreshScope
public class PayFlowServiceImpl extends BaseService implements PayFlowService {

    @Resource
    private PayFlowMapper payFlowMapper;

    @Resource
    private UserAmountMapper userAmountMapper;

    @Resource
    private UserRewardStatService userRewardStatService;

    @Resource
    private UserProperties userProperties;

    @Override
    public void modifyAccountFlowAndStatByGold(PayFlow payFlow, BigDecimal gold, boolean isAttribute) {
        logger.debug("payFlow:[{}],gold:[{}],isAttribute:[{}]", payFlow, gold, isAttribute);
        if (userProperties.isFlowSwitch()) {
            this.modifyAccountRelated(payFlow, gold);
        }
    }

    private void modifyAccountRelated(PayFlow payFlow, BigDecimal gold) {
        this.savePayFlow(payFlow, gold);
        this.userAmountMapper.updateUserAmount(payFlow.getUserId(), REWARD_TYPE_GOLD, gold, BigDecimal.ZERO);
        this.userRewardStatService.updateRewardByType(payFlow.getUserId(), payFlow.getTaskType(), gold);
    }

    private void savePayFlow(PayFlow payFlow, BigDecimal reward) {
        payFlow.setId(nextId());
        payFlow.setReward(reward);
        payFlow.setRemark(TaskEnum.getDescByType(payFlow.getTaskType()));
        if (this.payFlowMapper.insertSelective(payFlow) <= 0) {
            throw new RuntimeException("更新用户交易流水失败");
        }
    }

    @Override
    public List<FlowDetail> listPayFlowToday(Long userId, byte rewardType) {
        return this.payFlowMapper.listPayFlowToday(userId, rewardType);
    }

}
