package com.bxm.localnews.user.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.user.domain.UserAuthMapper;
import com.bxm.localnews.user.enums.AppConst;
import com.bxm.localnews.user.integration.BizLogIntegrationService;
import com.bxm.localnews.user.service.UserAuthService;
import com.bxm.localnews.user.service.UserService;
import com.bxm.localnews.user.vo.LoginInfo;
import com.bxm.localnews.user.vo.UserAuth;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * Created by mars on 2018/2/28.
 */
@Service("userAuthService")
@Slf4j
public class UserAuthServiceImpl implements UserAuthService {

    @Resource
    private UserAuthMapper userAuthMapper;

    @Resource
    private UserService userService;

    @Resource
    private BizLogIntegrationService bizLogIntegrationService;

    @Override
    public int addUserAuth(Byte type, Long userId, String identifier, String credential) {
        UserAuth auth = generateUserAuth(userId, type, identifier, credential);
        return this.userAuthMapper.insertSelective(auth);
    }

    @Override
    public UserAuth selectByUserAuth(Byte type, String openId) {
        //本地万事通需要创建用户
        log.info("根据登陆类型[{}]查询openId[{}]的相关信息", type, openId);
        if (AppConst.LOGIN_TYPE.WEIXIN_APPLET_WST_OPENID == type) {
            UserAuth userAuth = userAuthMapper.selectByUserAuth(type, openId);
            if (userAuth != null) {
                return userAuth;
            }

            log.info("当前登陆类型是【万事通小程序】--------创建静默用户");

            Long userId = userService.addWSTAppletUser();
            UserAuth auth = generateUserAuth(userId, type, openId, null);
            this.userAuthMapper.insertSelective(auth);

            log.info("创建静默用户成功：[{}]", JSON.toJSONString(auth));

            bizLogIntegrationService.newUser(userId, "wxapp", openId, BigDecimal.ZERO,
                    "MINI_WST", null, 5);
            return auth;
        } else {
            return userAuthMapper.selectByUserAuth(type, openId);
        }
    }

    @Override
    public UserAuth selectByUserAuth(Long userId, Byte type) {
        return userAuthMapper.selectByUserId(type, userId);
    }

    @Override
    public Message addUserAuthByWeixin(Long userId, String unionId, String openId) {
        UserAuth auth = generateUserAuth(userId, AppConst.LOGIN_TYPE.WEIXIN, unionId, null);
        this.userAuthMapper.insertSelective(auth);

        auth = generateUserAuth(userId, AppConst.LOGIN_TYPE.WEIXIN_OPENID, openId, null);
        this.userAuthMapper.insertSelective(auth);
        return Message.build();
    }

    @Override
    public void saveAuth(Long userId, LoginInfo loginInfo) {
        List<UserAuth> authList = new ArrayList<>();

        // 1.单纯手机号注册 2.手机号+微信注册 3.微信号注册
        UserAuth auth = new UserAuth();
        auth.setUserId(userId);
        auth.setType(loginInfo.getType());
        auth.setIdentifier(loginInfo.getLoginName());
        if (StringUtils.isNotBlank(loginInfo.getPassword())) {
            auth.setCredential(MD5Util.hgmd5(loginInfo.getPassword()));
        }
        authList.add(auth);
        log.warn("添加权限验证:{}", loginInfo.getLoginName());

        //如果三方注册
        if (AppConst.LOGIN_TYPE.PHONE != loginInfo.getType()) {
            //绑定三方的时候绑定手机
            if (null != loginInfo.getPhone()) {
                UserAuth phoneAuth = new UserAuth();
                phoneAuth.setUserId(userId);
                phoneAuth.setType(AppConst.LOGIN_TYPE.PHONE);
                phoneAuth.setIdentifier(loginInfo.getPhone());
                if (StringUtils.isNotBlank(loginInfo.getPassword())) {
                    phoneAuth.setCredential(MD5Util.hgmd5(loginInfo.getPassword()));
                }
                authList.add(phoneAuth);
            }

            //绑定三方的时候绑定openid
            if (loginInfo.getOpenId() != null) {
                UserAuth openIdAuth = new UserAuth();
                openIdAuth.setUserId(userId);
                openIdAuth.setType(AppConst.LOGIN_TYPE.APP_OPENID);
                openIdAuth.setIdentifier(loginInfo.getOpenId());
                if (StringUtils.isNotBlank(loginInfo.getPassword())) {
                    openIdAuth.setCredential(MD5Util.hgmd5(loginInfo.getPassword()));
                }
                authList.add(openIdAuth);
            }
        }

        this.userAuthMapper.batchAdd(authList);
    }

    /**
     * 生成auth对象
     *
     * @param userId
     * @param type
     * @param identifier
     * @param credential
     * @return
     */
    private UserAuth generateUserAuth(Long userId, Byte type, String identifier, String credential) {
        UserAuth auth = new UserAuth();
        auth.setUserId(userId);
        auth.setType(type);
        auth.setIdentifier(identifier);
        auth.setCredential(credential);
        return auth;
    }

}
