package com.bxm.localnews.user.service.impl;

import com.bxm.localnews.user.domain.UserEquipmentMapper;
import com.bxm.localnews.user.service.UserEquipmentService;
import com.bxm.localnews.user.vo.UserEquipment;
import com.bxm.newidea.component.vo.Message;

import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @author zhaoyadong 2019/4/16 14:52
 * @desc
 */
@Service
public class UserEquipmentServiceImpl implements UserEquipmentService {

    @Resource
    private UserEquipmentMapper userEquipmentMapper;

    @Override
    public UserEquipment selectByEquipment(String equipment) {
        return userEquipmentMapper.selectByEquipment(equipment);
    }

    @Override
    public Message addUserEquipment(UserEquipment userEquipment) {
        userEquipmentMapper.addEquipment(userEquipment);
        return Message.build();
    }

    @Override
    public Boolean checkExistEquipment(String equipment, String activityType) {
        return userEquipmentMapper.countEquipment(equipment, activityType) > 0;
    }
}
