package com.bxm.localnews.user.service.impl;

import java.util.Date;

import com.bxm.localnews.user.domain.UserLoginHistoryMapper;
import com.bxm.localnews.user.service.UserLoginHistoryService;
import com.bxm.localnews.user.vo.LoginInfo;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserLoginHistory;
import com.bxm.newidea.component.service.BaseService;

import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class UserLoginHistoryServiceImpl extends BaseService implements UserLoginHistoryService {

    @Resource
    private UserLoginHistoryMapper userLoginHistoryMapper;

    @Async
    @Override
    public void save(User user, LoginInfo loginInfo) {
        UserLoginHistory userLoginHistory = new UserLoginHistory();
        userLoginHistory.setEquipment(loginInfo.getEquipment());
        userLoginHistory.setId(nextSequence());
        userLoginHistory.setLastLoginIp(loginInfo.getLastLoginIp());
        userLoginHistory.setLastLoginTime(new Date());
        userLoginHistory.setOperatingSystem(loginInfo.getOperatingSystem());
        userLoginHistory.setPhoneModel(loginInfo.getPhonemodel());
        userLoginHistory.setUserId(user.getId());
        userLoginHistory.setClientVersion(loginInfo.getCurVer());
        userLoginHistory.setServerVersion(loginInfo.getVersion());
        userLoginHistoryMapper.insertSelective(userLoginHistory);
    }
}
