package com.bxm.localnews.user.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.user.integration.UserNewsIntegrationService;
import com.bxm.localnews.user.service.UserSyncService;
import com.bxm.localnews.user.vo.User;

import com.bxm.newidea.component.service.BaseService;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class UserSyncServiceImpl extends BaseService implements UserSyncService {

    @Resource
    private UserNewsIntegrationService userNewsIntegrationService;

    @Async
    @Override
    public void sync(User user) {
        logger.info("调用新闻模块更新用户冗余信息:[{}]", JSONObject.toJSONString(user));
        userNewsIntegrationService.syncUser(user);
    }
}
