package com.bxm.localnews.user.service.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

import com.bxm.localnews.user.config.WithdrawConfig;
import com.bxm.localnews.user.domain.WithdrawFlowMapper;
import com.bxm.localnews.user.dto.UserWithdrawDTO;
import com.bxm.localnews.user.dto.WithdrawConfigDTO;
import com.bxm.localnews.user.dto.WithdrawDTO;
import com.bxm.localnews.user.enums.WithdrawEnum;
import com.bxm.localnews.user.service.UserAccountService;
import com.bxm.localnews.user.service.UserWithdrawService;
import com.bxm.localnews.user.vo.UserAccount;
import com.bxm.localnews.user.vo.WithdrawFlow;
import com.bxm.newidea.component.service.BaseService;

import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;

/**
 * @author zhaoyadong 2019/3/6 10:18
 * @desc
 */
@Service
public class UserWithdrawServiceImpl extends BaseService implements UserWithdrawService {

    @Resource
    private WithdrawFlowMapper withdrawFlowMapper;

    @Resource
    private WithdrawConfig withdrawConfig;

    @Override
    public UserWithdrawDTO getUserRecentWithdrawInfo(Long userId) {
        WithdrawFlow withdrawFlow = withdrawFlowMapper.getUserLastWithdraw(userId);
        if (withdrawFlow == null) {
            return null;
        }

        UserWithdrawDTO userWithdrawDTO = new UserWithdrawDTO();
        userWithdrawDTO.setUserId(withdrawFlow.getUserId());
        userWithdrawDTO.setAmount(withdrawFlow.getAmount());
        userWithdrawDTO.setWithdrawNum(withdrawFlow.getOrderNo());
        userWithdrawDTO.setStatus(withdrawFlow.getState());

        return userWithdrawDTO;
    }

    @Override
    public WithdrawFlow getWithdrawFlowById(Long id) {
        return withdrawFlowMapper.getWithdrawFlowById(id);
    }

    @Override
    public BigDecimal getMiniAppUserWithdraw(Long userId, String openId, Byte state) {
        return withdrawFlowMapper.getMiniAppUserWithdraw(userId, openId, state);
    }

    @Override
    public WithdrawDTO getWithDrawList(Long userId, BigDecimal drawableCash, BigDecimal withdrawCash) {
        logger.debug("当前用户[{}]可提现金额为[{}]已提现金额为[{}]", userId, drawableCash, withdrawCash);
        WithdrawDTO withdrawDTO = new WithdrawDTO();
        withdrawDTO.setAvailableCash(drawableCash);
        //最后一笔提现信息
        WithdrawFlow withdrawFlow = withdrawFlowMapper.getUserLastWithdraw(userId);
        if (withdrawFlow != null && WithdrawEnum.FAIL_PAYMENT.getState().equals(withdrawFlow.getState())) {
            if ("V2_ACCOUNT_SIMPLE_BAN".equals(withdrawFlow.getRemark())) {
                withdrawDTO.setFailMsg("您的微信号未实名认证，提现失败，请实名认证后再提现");
            } else {
                withdrawDTO.setFailMsg("系统繁忙，请稍后再试");
            }
        }
        //判断已提现金额是否大于0
        if (BigDecimal.ZERO.compareTo(withdrawCash) == 0) {
            withdrawDTO.setWithdrawConfigDTOList(withdrawConfig.getNotWithdrawList());
        } else {
            //复制链表，防止后续对原链表的更改
            List<WithdrawConfigDTO> withdrawDTOList = copyWithdrawConfigDTOList();
            //已提现金额满10元
            if (withdrawCash.compareTo(BigDecimal.TEN) >= 0) {
                logger.debug("当前用户[{}]的2元提现增加限制", userId);
                WithdrawConfigDTO withdrawConfigDTO = withdrawDTOList.get(0);
                withdrawConfigDTO.setWithdrawNumber(1);

                //判断两元是否可以提现
                if (null == withdrawFlow) {
                    withdrawConfigDTO.setEnableWithdraw(true);
                } else {
                    //不需要获取用户当天所有的提现流水，只需取当天2块的提现成功流水即可
                    List<WithdrawFlow> withdrawFlowList = withdrawFlowMapper.getUserTodayWithdraw(
                            userId, WithdrawEnum.SUCCESS_PAYMENT.getState(), new BigDecimal(2));
                    if (CollectionUtils.isEmpty(withdrawFlowList)) {
                        withdrawConfigDTO.setEnableWithdraw(true);
                    } else {
                        logger.debug("当前用户[{}]今日已提现, 设置为今日不能提现");
                        withdrawConfigDTO.setEnableWithdraw(false);
                    }
                }
            }
            withdrawDTO.setWithdrawConfigDTOList(withdrawDTOList);
        }
        return withdrawDTO;
    }

    private List<WithdrawConfigDTO> copyWithdrawConfigDTOList() {
        List<WithdrawConfigDTO> withdrawDTOList = new ArrayList<>();
        withdrawConfig.getHavingWithdrawList().forEach(withdrawConfigDTO -> {
            WithdrawConfigDTO withdrawConfig = new WithdrawConfigDTO();
            BeanUtils.copyProperties(withdrawConfigDTO, withdrawConfig);
            withdrawDTOList.add(withdrawConfig);
        });
        return withdrawDTOList;
    }

}
