package com.bxm.localnews.user.adapter;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.user.vo.*;

/**
 * 传参适配器
 */
public class ParamAdapter {

    /**
     * 静默注册时参数适配
     * @param silentRegisterParam
     * @return
     */
    public static LoginInfo transformSilentRegisterToLoginInfo(SilentRegisterParam silentRegisterParam) {
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setEquipment(silentRegisterParam.getEquipment());
        loginInfo.setPhonemodel(silentRegisterParam.getPhonemodel());
        loginInfo.setRegisteredaddress(silentRegisterParam.getRegisteredaddress());
        return loginInfo;
    }

    /**
     * 有安卓端，ios端，h5前端三方面的注册，都通用这个类
     * 安卓端：1.手机号注册 2.第三方绑定注册
     * IOS端：1.手机号注册 2.第三方绑定注册
     * H5：1.手机号注册 2.第三方绑定注册
     * @param registerParam
     * @return
     */
    public static LoginInfo transformRegisterToLoginInfo(RegisterParam registerParam, BasicParam basicParam) {
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setEquipment(registerParam.getEquipment());
        loginInfo.setPhonemodel(registerParam.getPhonemodel());
        loginInfo.setRegisteredaddress(registerParam.getRegisteredaddress());
        loginInfo.setCode(registerParam.getCode());
        loginInfo.setHeadImg(registerParam.getHeadImg());
        loginInfo.setLoginName(registerParam.getLoginName());
        loginInfo.setNickname(registerParam.getNickname());
        loginInfo.setOpenId(registerParam.getOpenId());
        loginInfo.setPassword(registerParam.getPassword());
        loginInfo.setPhone(registerParam.getPhone());
        loginInfo.setInviteCode(registerParam.getInviteCode());
        loginInfo.setType(registerParam.getType());
        loginInfo.setId(registerParam.getId());
        loginInfo.setCurVer(basicParam.getCurVer());
        loginInfo.setVersion(basicParam.getVersion());
        loginInfo.setOperatingSystem(registerParam.getOperatingSystem());
        return loginInfo;
    }

    /**
     * 微信绑定
     * @param wechatBindParam
     * @return
     */
    public static LoginInfo transformWechatBindToLoginInfo(WechatBindParam wechatBindParam) {
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setHeadImg(wechatBindParam.getHeadImg());
        loginInfo.setLoginName(wechatBindParam.getLoginName());
        loginInfo.setNickname(wechatBindParam.getNickname());
        loginInfo.setType(wechatBindParam.getType());
        loginInfo.setId(wechatBindParam.getId());
        return loginInfo;
    }


    public static LoginInfo transformLoginParamToLoginInfo(LoginParam loginParam, BasicParam basicParam) {
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setEquipment(loginParam.getEquipment());
        loginInfo.setId(loginParam.getId());
        loginInfo.setCode(loginParam.getCode());
        loginInfo.setHeadImg(loginParam.getHeadImg());
        loginInfo.setLoginName(loginParam.getLoginName());
        loginInfo.setNickname(loginParam.getNickname());
        loginInfo.setPassword(loginParam.getPassword());
        loginInfo.setPhone(loginParam.getPhone());
        loginInfo.setInviteCode(loginParam.getInviteCode());
        loginInfo.setType(loginParam.getType());
        loginInfo.setResetPwd(loginParam.getResetPwd());
        loginInfo.setOpenId(loginParam.getOpenId());
        loginInfo.setUnionId(loginParam.getUnionId());
        loginInfo.setPhonemodel(loginParam.getPhonemodel());
        loginInfo.setOperatingSystem(loginParam.getOperatingSystem());
        loginInfo.setCurVer(basicParam.getCurVer());
        loginInfo.setVersion(basicParam.getVersion());
        return loginInfo;
    }

    public static LoginInfo transformH5Register(H5RegisterParam registerParam) {
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setCode(registerParam.getCode());
        loginInfo.setLoginName(registerParam.getLoginName());
        loginInfo.setPassword(registerParam.getPassword());
        loginInfo.setPhone(registerParam.getPhone());
        loginInfo.setInviteCode(registerParam.getInviteCode());
        loginInfo.setType(registerParam.getType());
        loginInfo.setId(registerParam.getId());
        return loginInfo;
    }

}
