package com.bxm.localnews.user.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties("user.config")
public class UserProperties {

    /**
     * 微信信息同步超时时间
     */
    private long wechatSyncTimeout;

    /**
     * 金币流水记录开关
     */
    private boolean flowSwitch;

    /**
     * 用户默认头像
     */
    private String defaultHeadImgUrl;

    /**
     * 用户生成token时的appKey
     */
    private String appKey;

    public String getDefaultHeadImgUrl() {
        return defaultHeadImgUrl;
    }

    public void setDefaultHeadImgUrl(String defaultHeadImgUrl) {
        this.defaultHeadImgUrl = defaultHeadImgUrl;
    }

    public boolean isFlowSwitch() {
        return flowSwitch;
    }

    public void setFlowSwitch(boolean flowSwitch) {
        this.flowSwitch = flowSwitch;
    }

    public long getWechatSyncTimeout() {
        return wechatSyncTimeout;
    }

    public void setWechatSyncTimeout(long wechatSyncTimeout) {
        this.wechatSyncTimeout = wechatSyncTimeout;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }
}
