package com.bxm.localnews.user.service.impl;

import com.bxm.localnews.activity.service.LevelConfigService;
import com.bxm.localnews.activity.vo.LevelConfig;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.service.BusinessCalService;
import com.bxm.localnews.user.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;

@Service
public class BusinessCalServiceImpl implements BusinessCalService {

    private UserService userService;

    private LevelConfigService levelConfigService;

    @Autowired
    public BusinessCalServiceImpl(UserService userService, LevelConfigService levelConfigService) {
        this.userService = userService;
        this.levelConfigService = levelConfigService;
    }

    @Override
    public BigDecimal calculateAttributedGold(Long userId, BigDecimal gold) {
        UserInfoDTO user = this.userService.getUserFromRedisDB(userId);
        int level = user.getLevel();

        List<LevelConfig> levelConfigList = this.levelConfigService.getLevelConfigs();

        for (LevelConfig levelConfig : levelConfigList) {
            if (levelConfig.getLevelType() == level) {
                return gold.multiply(levelConfig.getContributeRate());
            }
        }

        return gold;
    }

    @Override
    public BigDecimal calculateSubsidyGold(Byte level) {
        BigDecimal ret = BigDecimal.ZERO;
        List<LevelConfig> levelConfigList = this.levelConfigService.getLevelConfigs();
        for (LevelConfig levelConfig : levelConfigList) {
            if (levelConfig.getLevelType().equals(level)) {
                return levelConfig.getMonthReward();
            }
        }
        return ret;
    }

    @Override
    public int calculatePrenticeNum(Byte level) {
        int ret = 1000;
        List<LevelConfig> levelConfigList = this.levelConfigService.getLevelConfigs();
        for (LevelConfig levelConfig : levelConfigList) {
            if (levelConfig.getLevelType().equals(level)) {
                return levelConfig.getPupilLimit();
            }
        }
        return ret;
    }

}
