package com.bxm.localnews.user.service.impl;

import com.bxm.localnews.common.constant.UserRegChannelConstant;
import com.bxm.localnews.user.domain.RegSourceMapper;
import com.bxm.localnews.user.service.RegSourceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author liujia 2018/8/11 19:47
 */
@Service
public class RegSourceServiceImpl implements RegSourceService {

    private RegSourceMapper regSourceMapper;

    @Autowired
    public RegSourceServiceImpl(RegSourceMapper regSourceMapper) {
        this.regSourceMapper = regSourceMapper;
    }

    @Override
    public int getEffectiveInviteCount(Long inviteUserId, Byte type) {
        Integer count = this.regSourceMapper.getEffectiveInviteCount(inviteUserId, type);
        return count == null ? 0 : count;
    }

    @Override
    public Long getInviteUserId(Long userId) {
        return this.regSourceMapper.getInviteUserId(userId, UserRegChannelConstant.RED_PACKAGE);
    }

}
