package com.bxm.localnews.user.service.impl;

import com.bxm.localnews.user.domain.UserActiveMapper;
import com.bxm.localnews.user.service.UserActiveService;
import com.bxm.localnews.user.vo.UserActive;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service
public class UserActiveServiceImpl implements UserActiveService {

    private UserActiveMapper userActiveMapper;

    @Autowired
    public UserActiveServiceImpl(UserActiveMapper userActiveMapper) {
        this.userActiveMapper = userActiveMapper;
    }

    @Override
    public int upsert(Long userId, Date updateTime) {
        return this.userActiveMapper.upsert(new UserActive(userId, updateTime));
    }

}
