package com.bxm.localnews.user.service.impl;

import com.bxm.localnews.user.domain.UserAddressBookMapper;
import com.bxm.localnews.user.service.UserAddressBookService;
import com.bxm.localnews.user.vo.UserAddressBook;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * Created by mars on 2018/3/6.
 */
@Service("userAddressBookService")
public class UserAddressBookServiceImpl implements UserAddressBookService {

    @Resource
    private UserAddressBookMapper userAddressBookMapper;

    @Override
    public void addUserAddressBook(UserAddressBook userAddressBook) {
        UserAddressBook book = this.userAddressBookMapper.getUserAddressBookByPhone(userAddressBook.getUserId(), userAddressBook.getPhone());
        if (null != book) {
            book.setName(userAddressBook.getName());
            this.userAddressBookMapper.updateByPrimaryKeySelective(book);
        } else {
            this.userAddressBookMapper.insertSelective(userAddressBook);
        }
    }

}
