package com.bxm.localnews.user.service.impl;

import com.bxm.localnews.common.constant.AppConst;
import com.bxm.localnews.common.constant.TaskEnum;
import com.bxm.localnews.user.constant.DeductPointStatusEnum;
import com.bxm.localnews.user.domain.PointOrderMapper;
import com.bxm.localnews.user.domain.UserAmountMapper;
import com.bxm.localnews.user.param.DeductPointParam;
import com.bxm.localnews.user.param.StoreNeceParam;
import com.bxm.localnews.user.service.PayFlowService;
import com.bxm.localnews.user.service.UserAmountService;
import com.bxm.localnews.user.vo.PayFlow;
import com.bxm.localnews.user.vo.PointOrder;
import com.bxm.localnews.user.vo.UserAmount;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.Message;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.Date;

/**
 * Created by Administrator on 2018/2/23.
 */
@Service("userAmountService")
public class UserAmountServiceImpl extends BaseService implements UserAmountService {

    @Resource
    private UserAmountMapper userAmountMapper;

    @Resource
    private PointOrderMapper pointOrderMapper;

    @Resource
    private PayFlowService payFlowService;

    @Override
    public UserAmount findAmountByUserId(Long userId) {
        return this.userAmountMapper.selectByUserId(userId);
    }

    @Override
    public Message createAccount(Long userId) {
        return Message.build(this.userAmountMapper.insertSelective(new UserAmount(userId)));
    }

    @Override
    public BigDecimal selectJbBalanceByUserId(StoreNeceParam storeNeceParam) {
        BigDecimal point = selectGoldBalanceByUserId(Long.valueOf(storeNeceParam.getAppUid()));
        return point;
    }

    @Override
    public void addUserBalance(DeductPointParam deductPointParam) {

        //保存订单记录
        PointOrder pointOrder = addPointOrder(deductPointParam);

        //更新用户金币
        BigDecimal addPoint = new BigDecimal(deductPointParam.getPoint().longValue());
        PayFlow payFlow = PayFlow.initPayFlow(Long.valueOf(deductPointParam.getAppUid()),
                TaskEnum.STORE_ADD_BALANCE.getType(), AppConst.REWARD_TYPE_GOLD,
                pointOrder.getId().toString());

        payFlowService.modifyAccountFlowAndStatByGold(payFlow, addPoint, false);

    }

    @Override
    public BigDecimal selectGoldBalanceByUserId(Long userId) {
        UserAmount userAmount = userAmountMapper.selectByUserId(userId);
        if (null != userAmount) {
            return userAmount.getJbBalance();
        }
        return null;
    }

    /**
     * 添加订单记录
     * @param deductPointParam
     * @return
     */
    private PointOrder addPointOrder(DeductPointParam deductPointParam) {
        PointOrder pointOrder = new PointOrder();
        pointOrder.setBxmOrderNo(deductPointParam.getOrderNum());
        pointOrder.setOrderNo(deductPointParam.getAppOrderNum());
        pointOrder.setUserId(Long.valueOf(deductPointParam.getAppUid()));
        pointOrder.setDeductBalance(deductPointParam.getPoint().longValue());
        pointOrder.setDescription(deductPointParam.getDescription());
        pointOrder.setStatus(deductPointParam.getStatus());
        pointOrder.setCreateTime(new Date());
        pointOrderMapper.insertSelective(pointOrder);

        return pointOrder;
    }

    @Override
    public Boolean deductUserBalance(DeductPointParam deductPointParam) {

        //获取用户金币
        BigDecimal userBalance = this.userAmountMapper.selectByUserId(Long.valueOf(deductPointParam.getAppUid())).getJbBalance();

        //比较扣除的金币
        BigDecimal deductPoint = new BigDecimal(deductPointParam.getPoint().longValue());
        if (userBalance.compareTo(deductPoint) < 0) {
            return Boolean.FALSE;
        }

        //保存订单记录
        PointOrder pointOrder = addPointOrder(deductPointParam);

        //更新用户金币
        PayFlow payFlow = PayFlow.initPayFlow(Long.valueOf(deductPointParam.getAppUid()),
                TaskEnum.BALANCE_EXCHANGE_GOODS.getType(), AppConst.REWARD_TYPE_GOLD,
                pointOrder.getId().toString());
        payFlowService.modifyAccountFlowAndStatByGold(payFlow, new BigDecimal("-" + deductPoint.longValue()), false);

        return Boolean.TRUE;
    }

    @Override
    public void deductConfirmUserBalance(DeductPointParam deductPointParam) {

        //获取订单信息
        PointOrder pointOrder = pointOrderMapper.getPointOrder(Long.valueOf(deductPointParam.getAppUid()),
                deductPointParam.getOrderNum());
        if (pointOrder != null) {

            String status = DeductPointStatusEnum.getStatusByStatus(deductPointParam.getStatus());
            if (DeductPointStatusEnum.FAIL.getStatus().equals(status)) {
                //返还用户金币
                PayFlow payFlow = PayFlow.initPayFlow(Long.valueOf(deductPointParam.getAppUid()),
                        TaskEnum.BALANCE_EXCHANGE_GOODS.getType(), AppConst.REWARD_TYPE_GOLD,
                        pointOrder.getId().toString());
                payFlowService.modifyAccountFlowAndStatByGold(payFlow, new BigDecimal(pointOrder.getDeductBalance()), false);
            }

            //更新订单信息
            pointOrder.setUpdateTime(new Date());
            pointOrder.setStatus(deductPointParam.getStatus());
            pointOrderMapper.updateByPrimaryKeySelective(pointOrder);
        }

    }
}
