package com.bxm.localnews.user.service.impl;

import com.bxm.localnews.common.constant.AppConst;
import com.bxm.localnews.user.domain.UserAuthMapper;
import com.bxm.localnews.user.service.UserAuthSupplyService;
import com.bxm.localnews.user.vo.UserAuth;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author zhaoyadong 2018/10/17 16:37
 * @desc
 */
@Service
public class UserAuthSupplyServiceImpl implements UserAuthSupplyService {

    private UserAuthMapper userAuthMapper;

    @Autowired
    public UserAuthSupplyServiceImpl(UserAuthMapper userAuthMapper) {
        this.userAuthMapper = userAuthMapper;
    }

    @Override
    public UserAuth selectByUserAuth(String openId) {
        return userAuthMapper.selectByUserAuth(AppConst.LOGIN_TYPE.WEIXIN, openId);
    }
}
