package com.bxm.localnews.user.service.impl;

import com.bxm.localnews.activity.dto.SignWarper;
import com.bxm.localnews.activity.service.NoviceTaskRecordService;
import com.bxm.localnews.activity.service.SignFacadeService;
import com.bxm.localnews.activity.service.VipFacadeService;
import com.bxm.localnews.common.constant.LevelEunm;
import com.bxm.localnews.common.constant.PhoneTyeEnum;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.message.service.MessageUserService;
import com.bxm.localnews.user.config.UserProperties;
import com.bxm.localnews.user.domain.UserMapper;
import com.bxm.localnews.user.dto.UserBaseInfoDTO;
import com.bxm.localnews.user.dto.UserInfoBto;
import com.bxm.localnews.user.service.UserAmountService;
import com.bxm.localnews.user.service.UserBaseInfoService;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserAmount;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import static com.bxm.localnews.common.constant.TaskEnum.TASK_IMPROVE_USER_INFO;

/**
 * Created by Administrator on 2017/12/19.
 */

@Service
public class UserBaseInfoServiceImpl extends BaseService implements UserBaseInfoService {

    private static String LOGIN_BIND_NO = "未绑定";

    private static String LOGIN_BIND_YES = "已绑定";

    @Resource
    RedisStringAdapter redisStringAdapter;

    @Resource
    private UserMapper userBaseInfoMapper;

    @Resource
    private UserAmountService userAmountService;

    @Resource
    private VipFacadeService vipFacadeService;

    @Resource
    private SignFacadeService signFacadeService;

    @Resource
    private UserProperties userProperties;

    @Resource
    private NoviceTaskRecordService noviceTaskRecordService;

    @Resource
    private MessageUserService messageUserService;

    @Override
    public User selectByUserId(Long userId) {
        User user = this.userBaseInfoMapper.selectByUserId(userId);
        if (null != user) {
            if (StringUtils.isNotEmpty(user.getRegisterClient()) && null != user.getRegisterClient()) {
                user.setRegisterClient(PhoneTyeEnum.getPhoneTyeEnum(user.getRegisterClient()));
            }
            if (StringUtils.isNotEmpty(String.valueOf(user.getLevel())) && null != user.getLevel()) {
                user.setLevelStr(LevelEunm.getLevelEunm(user.getLevel()));
            }
            if (StringUtils.isEmpty(user.getWeibo()) || null == user.getWeibo()) {
                user.setWeibo(LOGIN_BIND_NO);
            } else {
                user.setWeibo(LOGIN_BIND_YES);
            }
            if (StringUtils.isEmpty(user.getWeixin()) || null == user.getWeixin()) {
                user.setWeixin(LOGIN_BIND_NO);
            } else {
                user.setWeixin(LOGIN_BIND_YES);
            }
            if (StringUtils.isEmpty(user.getQq()) || null == user.getQq()) {
                user.setQq(LOGIN_BIND_NO);
            } else {
                user.setQq(LOGIN_BIND_YES);
            }
        }
        return user;
    }

    @Override
    public Page<UserInfoBto> getUserByConditon(UserInfoBto userInfoBto, int currentPage, int pageSize) {
        PageHelper.startPage(currentPage, pageSize);
        List<UserInfoBto> list = this.userBaseInfoMapper.selectUserByConditon(userInfoBto);
        for (UserInfoBto userInfo : list) {
            userInfo.setRegisterClient(PhoneTyeEnum.getPhoneTyeEnum(userInfo.getRegisterClient()));
        }
        return (Page<UserInfoBto>) list;
    }

    @Override
    public boolean updateUserBlack(Map<String, Object> map) {
        return this.userBaseInfoMapper.updateUserBlack(map);
    }

    @Override
    public UserBaseInfoDTO getUserInfoForWST(Long userId, int platform) {
        //得到用户基本信息
        if (null == userId) {
            logger.error("用户id不能为空");
            return null;
        }
        User user = this.userBaseInfoMapper.selectByUserId(userId);
        if (null != user) {
            //获取用户签到信息(已废弃)
            SignWarper signWarper = signFacadeService.listSignRecord(userId, platform);

            //得到用户VIP邀请人数
            int count = vipFacadeService.countVipByUser(userId);
            //得到用户账号取得总金币
            UserAmount userAmount = userAmountService.findAmountByUserId(userId);
            UserBaseInfoDTO userBaseInfoDTO = new UserBaseInfoDTO();
            if (userAmount != null) {
                userBaseInfoDTO.setGoldNum(userAmount.getJbBalance().compareTo(BigDecimal.ZERO) == 0 ? null : userAmount.getJbBalance().intValue());
            }
            userBaseInfoDTO.setNickname(StringUtils.isBlank(user.getNickname()) ? StringUtils.hideMobile(user.getPhone()) : user.getNickname());
            userBaseInfoDTO.setHeadImg(StringUtils.isBlank(user.getHeadImg()) ? userProperties.getDefaultHeadImgUrl() : user.getHeadImg());
            userBaseInfoDTO.setInviteNum(count);
            userBaseInfoDTO.setPhone(user.getPhone());
            userBaseInfoDTO.setSignWarper(signWarper);
            userBaseInfoDTO.setMaterialFinished(checkCompleteInfo(user.getId()));

            //获取通知红点
            KeyGenerator redPointKey = RedisConfig.MSG_RED_POINT.copy().appendKey(userId);
            Boolean redPoint = redisStringAdapter.get(redPointKey, Boolean.class);
            if (redPoint == null) {
                redPoint = Boolean.FALSE;
            }
            userBaseInfoDTO.setRedPoint(redPoint);
            int msgCount = messageUserService.countTotalMsg(userId);
            userBaseInfoDTO.setNoticeNum(msgCount);
            return userBaseInfoDTO;
        } else {
            return null;
        }
    }

    /**
     * 检查用户是否已经完善资料，如果已经完善则不显示“完善个人资料”按钮
     * 用户可以通过点击头像更改个人信息
     * @param userId
     * @return
     */
    private boolean checkCompleteInfo(Long userId) {
        return noviceTaskRecordService.isTaskCompleted(userId, TASK_IMPROVE_USER_INFO.getDesc());
    }

}
