package com.bxm.localnews.user.service.impl;

import com.bxm.localnews.common.constant.TaskEnum;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.constant.GoldRewadTypeEnum;
import com.bxm.localnews.user.constant.RewardTypeEnum;
import com.bxm.localnews.user.domain.UserAmountMapper;
import com.bxm.localnews.user.domain.UserRewardStatMapper;
import com.bxm.localnews.user.service.PayFlowService;
import com.bxm.localnews.user.service.UserRewardStatService;
import com.bxm.localnews.user.vo.*;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import static com.bxm.localnews.common.constant.AppConst.REWARD_TYPE_GOLD;

@Service
public class UserRewardStatServiceImpl implements UserRewardStatService {

    private final static Logger logger = LoggerFactory.getLogger(UserRewardStatServiceImpl.class);

    @Resource
    private UserRewardStatMapper userRewardStatMapper;

    @Resource
    private UserAmountMapper userAmountMapper;

    private PayFlowService payFlowService;

    private PayFlowService getPayFlowService() {
        if (null == this.payFlowService) {
            this.payFlowService = SpringContextHolder.getBean(PayFlowService.class);
        }
        return this.payFlowService;
    }

    @Override
    public void updateRewardByType(Long userId, Byte taskType, BigDecimal retGold) {
        UserRewardStat stat = this.userRewardStatMapper.selectDailyStat(userId, new Date());
        if (stat == null) {
            stat = UserRewardStat.initUserRewardStat(userId, this.userAmountMapper.getIdByUserId(userId));
            if (stat.getUserAmountId() == null || stat.getUserAmountId() == 0) {
                logger.error("[{}]没有对应的账号（a_user_amount表中无记录）,请检查业务逻辑", userId);
            } else {
                this.injectValueByTaskType(stat, taskType, retGold, userId);
                this.userRewardStatMapper.insertSelective(stat);
            }
        } else {
            UserRewardStat newStat = new UserRewardStat();
            newStat.setId(stat.getId());
            newStat.setUpdateTime(new Date());
            this.injectValueByTaskType(newStat, taskType, retGold, userId);
            this.userRewardStatMapper.updateRewardByType(newStat);
        }
    }

    private void injectValueByTaskType(UserRewardStat stat, Byte taskType, BigDecimal retGold, Long userId) {
        String[] tableColumByType = TaskEnum.getTableColumByType(taskType);
        for (String column : tableColumByType) {
            try {
                Field field = stat.getClass().getDeclaredField(column);
                field.setAccessible(true);
                //该字段表示:用户进贡给师父的金币.  需要根据用户等级计算实际金币
                if ("tribute".equals(column)) {
//                    InviteRelation inviteRelation = this.inviteRelationService.getInviteRelationByUserId(userId);
//                    if (null != inviteRelation) {
//                        BigDecimal tributeGold = this.businessCalService.calculateAttributedGold(inviteRelation.getUpUserId(), retGold);
//                        field.set(stat, tributeGold);
//                    }
                } else {
                    field.set(stat, retGold);
                }
            } catch (Exception e) {
                logger.info("inject reward value error ", e);
            }
        }
    }

    @Override
    public Json<GoldInfoModel> myGoldStat(Long userId) {
        UserAmount account = this.userAmountMapper.selectByUserId(userId);
        BigDecimal goldYesterday = this.userRewardStatMapper.getRewardGoldYesterday(userId);
        List<FlowDetail> flows = this.getPayFlowService().listPayFlowToday(userId, REWARD_TYPE_GOLD);
        GoldInfoModel goldInfoModel = new GoldInfoModel(account.getJbBalance(), goldYesterday, flows);
        return ResultUtil.genSuccessResult(goldInfoModel);
    }

    @Override
    public Json<MyGold> myGoldDetail(Long userId) {
        UserRewardStat yesterday = this.userRewardStatMapper.selectRewardDetail(userId);
        MyGold myGold = new MyGold();
        if (yesterday == null) {
            yesterday = new UserRewardStat();
            myGold.setTotalGold(BigDecimal.ZERO);
        } else {
            BigDecimal totalGold = yesterday.getGoldReward() == null ? BigDecimal.ZERO : yesterday.getGoldReward();
            myGold.setTotalGold(totalGold);
        }
        List<GoldCoinDetailModel> detail = new ArrayList<>();
        GoldRewadTypeEnum[] values = GoldRewadTypeEnum.values();
        for (GoldRewadTypeEnum typeEnum : values) {
            detail = this.invokeFieldByType(typeEnum, yesterday, detail);
        }
        myGold.setGoldDetail(detail);
        return ResultUtil.genSuccessResult(myGold);
    }

    private List<GoldCoinDetailModel> invokeFieldByType(RewardTypeEnum typeEnum, UserRewardStat yesterday, List<GoldCoinDetailModel> detail) {
        Field[] declaredFields = UserRewardStat.class.getDeclaredFields();
        try {
            for (Field field : declaredFields) {
                if (typeEnum.getField().equals(field.getName())) {
                    field.setAccessible(true);
                    Object value = field.get(yesterday);
                    if (null != value && StringUtils.isNotBlank(value.toString())) {
                        BigDecimal ret = new BigDecimal(value.toString());
                        if (ret.compareTo(BigDecimal.ZERO) != 0) {
                            String desc = typeEnum.getDesc();
                            GoldCoinDetailModel detailModel = new GoldCoinDetailModel(desc, ret);
                            detail.add(detailModel);
                        }
                    }
                }
            }
        } catch (IllegalAccessException e) {
            logger.error(e.getMessage(), e);
        }
        return detail;
    }

}
