package com.bxm.localnews.user.service.impl;

import com.bxm.localnews.common.constant.TaskEnum;
import com.bxm.localnews.user.domain.WaitRewardMapper;
import com.bxm.localnews.user.domain.WaitRewardRecordMapper;
import com.bxm.localnews.user.dto.UserRewardStatDTO;
import com.bxm.localnews.user.service.WaitRewardService;
import com.bxm.localnews.user.vo.WaitReward;
import com.bxm.localnews.user.vo.WaitRewardRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by mars on 2018/3/2.
 * 待发放奖励业务
 */
@Service("waitRewardService")
public class WaitRewardServiceImpl implements WaitRewardService {

    private final static Logger logger = LoggerFactory.getLogger(WaitRewardServiceImpl.class);

    @Resource
    private WaitRewardMapper waitRewardMapper;

    @Resource
    private WaitRewardRecordMapper waitRewardRecordMapper;

    private static void listSort(List<UserRewardStatDTO> list) {
        list.sort((o1, o2) -> {
            SimpleDateFormat format = new SimpleDateFormat("MM-dd");
            try {
                Date dt1 = format.parse(o1.getStatDate());
                Date dt2 = format.parse(o2.getStatDate());
                if (dt1.getTime() > dt2.getTime()) {
                    return -1;
                } else if (dt1.getTime() < dt2.getTime()) {
                    return 1;
                } else {
                    return 0;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        });
    }

    /**
     * 添加待发放奖励单次派发
     *
     * @param waitReward
     * @return
     */
    private int addWaitReward(WaitReward waitReward) {
        this.waitRewardMapper.insertSelective(waitReward);
        WaitRewardRecord waitRecord = new WaitRewardRecord();
        waitRecord.setWaitId(waitReward.getId());
        waitRecord.setSendState(waitReward.getSendState());
        waitRecord.setSendTime(waitReward.getSendTime());
        waitRecord.setReward(waitReward.getReward());
        waitRecord.setRewardType(waitReward.getRewardType());
        waitRecord.setRemark(waitReward.getRemark());
        this.waitRewardRecordMapper.insertSelective(waitRecord);
        return 1;
    }

    /**
     * 组装待发放奖励详情列表
     *
     * @param waitReward
     * @param rewards
     * @return
     */
    private List<WaitRewardRecord> batch(WaitReward waitReward, String[] rewards) {
        List<WaitRewardRecord> recordList = new ArrayList<>();
        for (String reward : rewards) {
            WaitRewardRecord waitRecord = new WaitRewardRecord();
            BigDecimal bd = new BigDecimal(reward);
            waitRecord.setWaitId(waitReward.getId());
            waitRecord.setSendState(waitReward.getSendState());
            waitRecord.setSendTime(waitReward.getSendTime());
            waitRecord.setReward(bd);
            waitRecord.setRewardType(waitReward.getRewardType());
            waitRecord.setRemark(waitReward.getRemark());
            recordList.add(waitRecord);
        }
        return recordList;
    }

    @Override
    public int addWaitReward(TaskEnum taskType, WaitReward waitReward) {
        switch (taskType.getType()) {
            default:
                this.addWaitReward(waitReward);
                //其他
        }
        return 1;
    }
}
