/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.account.impl;

import com.bxm.localnews.user.account.PayFlowService;
import com.bxm.localnews.user.account.UserRewardStatService;
import com.bxm.localnews.user.domain.PayFlowMapper;
import com.bxm.localnews.user.domain.UserAmountMapper;
import com.bxm.localnews.user.enums.TaskEnum;
import com.bxm.localnews.user.properties.UserProperties;
import com.bxm.localnews.user.vo.FlowDetail;
import com.bxm.localnews.user.vo.PayFlow;
import com.bxm.newidea.component.service.BaseService;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@Service
@RefreshScope
public class PayFlowServiceImpl
extends BaseService
implements PayFlowService {
    @Resource
    private PayFlowMapper payFlowMapper;
    @Resource
    private UserAmountMapper userAmountMapper;
    @Resource
    private UserRewardStatService userRewardStatService;
    @Resource
    private UserProperties userProperties;

    @Override
    public void modifyAccountFlowAndStatByGold(PayFlow payFlow, BigDecimal gold, boolean isAttribute) {
        this.logger.debug("payFlow:[{}],gold:[{}],isAttribute:[{}]", new Object[]{payFlow, gold, isAttribute});
        if (this.userProperties.isFlowSwitch()) {
            this.modifyAccountRelated(payFlow, gold);
        }
    }

    private void modifyAccountRelated(PayFlow payFlow, BigDecimal gold) {
        this.savePayFlow(payFlow, gold);
        this.userAmountMapper.updateUserAmount(payFlow.getUserId(), 10, gold, BigDecimal.ZERO);
        this.userRewardStatService.updateRewardByType(payFlow.getUserId(), payFlow.getTaskType(), gold);
    }

    private void savePayFlow(PayFlow payFlow, BigDecimal reward) {
        payFlow.setId(Long.valueOf(this.nextId()));
        payFlow.setReward(reward);
        payFlow.setRemark(TaskEnum.getDescByType((byte)payFlow.getTaskType()));
        if (this.payFlowMapper.insertSelective(payFlow) <= 0) {
            throw new RuntimeException("\u66f4\u65b0\u7528\u6237\u4ea4\u6613\u6d41\u6c34\u5931\u8d25");
        }
    }

    @Override
    public List<FlowDetail> listPayFlowToday(Long userId, byte rewardType) {
        return this.payFlowMapper.listPayFlowToday(userId, rewardType);
    }
}

