/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.account.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.param.PointReportParam;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.user.account.ProcessorService;
import com.bxm.localnews.user.account.UserAccountService;
import com.bxm.localnews.user.account.impl.AccountHandlerProxy;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.enums.AccountActionEnum;
import com.bxm.localnews.user.enums.GoldFlowTypeEnum;
import com.bxm.localnews.user.exception.UserAccountHandlerNotEnoughException;
import com.bxm.localnews.user.integration.BizLogIntegrationService;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.param.AccountActionParam;
import com.bxm.localnews.user.param.TransformParam;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;

@Service
public class ProcessorServiceImpl
extends BaseService
implements ProcessorService {
    private static final Logger log = LoggerFactory.getLogger(ProcessorServiceImpl.class);
    private final RedisListAdapter redisListAdapter;
    private final RedisSetAdapter redisSetAdapter;
    private final UserAccountService userAccountService;
    private final UserService userService;
    private final DataSourceTransactionManager dstManager;
    private final BizLogIntegrationService bizLogIntegrationService;
    private final AccountHandlerProxy accountHandlerProxy;

    @Override
    @Async
    public void doFlowerPresentConsume(Long userId, Long targetUserId) {
        String name = userId + ":" + targetUserId;
        log.debug("\u8fdb\u5165\u5904\u7406\u5668\uff0c\u5904\u7406\u5668\u540d\uff1a[{}]", (Object)name);
        UserInfoDTO user = this.userService.getUserFromRedisDB(userId);
        UserInfoDTO targetUser = this.userService.getUserFromRedisDB(targetUserId);
        if (null == user || null == targetUser) {
            log.error("\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u76f4\u63a5\u9000\u51fa");
            return;
        }
        KeyGenerator queueKeyGenerator = RedisConfig.USER_PRESENT_FLOWER_QUEUE.copy().appendKey((Object)name);
        KeyGenerator processorKeyGenerator = RedisConfig.USER_PRESENT_FLOWER_PROCESSOR.copy();
        List<TransformParam> transformParamList = new ArrayList<TransformParam>();
        try {
            while (true) {
                TransformParam t;
                if (null == (t = (TransformParam)this.redisListAdapter.blockRightPop(queueKeyGenerator, TransformParam.class, 2L, TimeUnit.SECONDS))) break;
                log.debug("\u4eceredis\u4e2d\u53d6\u51fa\u6570\u636e:[{}]", JSONObject.toJSON((Object)t));
                transformParamList.add(t);
            }
            log.debug("\u5728\u7b49\u5f852\u79d2\u949f\u540e\uff0c\u961f\u5217\u4ecd\u65e0\u6570\u636e\uff0c\u53ef\u4ee5\u5f00\u59cb\u8fdb\u884c\u6570\u636e\u5904\u7406");
            log.debug("\u5f00\u59cb\u8f6c\u79fb\u5c0f\u7ea2\u82b1\u6570\u91cf");
            transformParamList = ((ProcessorService)SpringContextHolder.getBean(ProcessorService.class)).calculateFlowerNum(transformParamList, user, targetUser);
            log.debug("\u5f00\u59cb\u751f\u4ea7\u5c0f\u7ea2\u82b1\u660e\u7ec6:[{}]", JSONObject.toJSON(transformParamList));
            if (!CollectionUtils.isEmpty(transformParamList)) {
                this.doDataReport(transformParamList);
            }
        }
        catch (Exception e) {
            try {
                log.error("\u5904\u7406\u5668\u51fa\u73b0\u9519\u8bef,\u5c06\u6570\u636e\u91cd\u65b0\u653e\u5165redis\uff0c\u5e76\u5411\u4e0a\u7ea7\u629b\u51fa");
                if (!CollectionUtils.isEmpty(transformParamList)) {
                    this.redisListAdapter.leftPush(queueKeyGenerator, transformParamList);
                }
                throw e;
            }
            catch (Throwable throwable) {
                log.debug("\u5904\u7406\u5b8c\u6bd5\uff0c\u5c06\u5904\u7406\u5668\u5220\u9664");
                this.redisSetAdapter.remove(processorKeyGenerator, new Object[]{name});
                throw throwable;
            }
        }
        log.debug("\u5904\u7406\u5b8c\u6bd5\uff0c\u5c06\u5904\u7406\u5668\u5220\u9664");
        this.redisSetAdapter.remove(processorKeyGenerator, new Object[]{name});
    }

    private void doDataReport(List<TransformParam> transformParamList) {
        for (TransformParam param : transformParamList) {
            PointReportParam reportParam = PointReportParam.build((BasicParam)param);
            reportParam.e("3034");
            reportParam.ev(StringUtils.join((Object[])new Serializable[]{"112.", param.getNum(), ".", String.valueOf(param.getTargetUserId())}));
            reportParam.put("uid", String.valueOf(param.getUserId()));
            reportParam.put("a", Objects.toString(param.getAreaCode()));
            this.bizLogIntegrationService.point(reportParam);
            if (!log.isDebugEnabled()) continue;
            log.debug("\u4e0a\u4f20userId: [{}] \u9886\u53d6\u5c0f\u7ea2\u82b1: [{}]\u4e8b\u4ef6\uff0c\u8bf7\u6c42\u53c2\u6570: {}", new Object[]{param.getTargetUserId(), param.getNum(), reportParam});
        }
    }

    @Override
    public List<TransformParam> calculateFlowerNum(List<TransformParam> transformParamList, UserInfoDTO user, UserInfoDTO targetUser) throws UserAccountHandlerNotEnoughException {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus transaction = this.dstManager.getTransaction((TransactionDefinition)def);
        Integer userAccount = this.userAccountService.getUserUsableGold(user.getId());
        int[] sum = new int[]{0};
        ArrayList<TransformParam> finalTransformParamList = new ArrayList<TransformParam>();
        transformParamList.forEach(e -> {
            if (sum[0] + e.getNum() <= userAccount) {
                sum[0] = sum[0] + e.getNum();
                finalTransformParamList.add((TransformParam)e);
            }
        });
        try {
            AccountActionParam sendParam = AccountActionParam.goldBuilder((AccountActionEnum)AccountActionEnum.CONSUME_GOLD).userId(user.getId()).goldNum(Integer.valueOf(sum[0])).goldFlowType(GoldFlowTypeEnum.FLOWER_PRESENT).content("\u8d60\u9001\u3010" + targetUser.getNickname() + "\u3011\u6d88\u8017\u5c0f\u7ea2\u82b1").build();
            this.accountHandlerProxy.handle(sendParam);
            AccountActionParam receiveParam = AccountActionParam.goldBuilder((AccountActionEnum)AccountActionEnum.ADD_USABLE_GOLD).userId(targetUser.getId()).goldNum(Integer.valueOf(sum[0])).goldFlowType(GoldFlowTypeEnum.FLOWER_PRESENT).content("\u6536\u5230\u3010" + user.getNickname() + "\u3011\u8d60\u9001\u7684\u5c0f\u7ea2\u82b1").build();
            this.accountHandlerProxy.handle(receiveParam);
        }
        catch (Exception e2) {
            this.dstManager.rollback(transaction);
            throw e2;
        }
        this.dstManager.commit(transaction);
        return finalTransformParamList;
    }

    @Autowired
    public ProcessorServiceImpl(RedisListAdapter redisListAdapter, RedisSetAdapter redisSetAdapter, UserAccountService userAccountService, UserService userService, DataSourceTransactionManager dstManager, BizLogIntegrationService bizLogIntegrationService, AccountHandlerProxy accountHandlerProxy) {
        this.redisListAdapter = redisListAdapter;
        this.redisSetAdapter = redisSetAdapter;
        this.userAccountService = userAccountService;
        this.userService = userService;
        this.dstManager = dstManager;
        this.bizLogIntegrationService = bizLogIntegrationService;
        this.accountHandlerProxy = accountHandlerProxy;
    }
}

