/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.account.impl;

import com.bxm.localnews.user.account.UserWithdrawService;
import com.bxm.localnews.user.domain.WithdrawFlowMapper;
import com.bxm.localnews.user.dto.UserWithdrawDTO;
import com.bxm.localnews.user.dto.WithdrawDTO;
import com.bxm.localnews.user.enums.WithdrawEnum;
import com.bxm.localnews.user.model.WithdrawConfigDTO;
import com.bxm.localnews.user.properties.WithdrawConfig;
import com.bxm.localnews.user.vo.WithdrawFlow;
import com.bxm.newidea.component.service.BaseService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserWithdrawServiceImpl
extends BaseService
implements UserWithdrawService {
    @Resource
    private WithdrawFlowMapper withdrawFlowMapper;
    @Resource
    private WithdrawConfig withdrawConfig;

    @Override
    public UserWithdrawDTO getUserRecentWithdrawInfo(Long userId) {
        WithdrawFlow withdrawFlow = this.withdrawFlowMapper.getUserLastWithdraw(userId);
        if (withdrawFlow == null) {
            return null;
        }
        UserWithdrawDTO userWithdrawDTO = new UserWithdrawDTO();
        userWithdrawDTO.setUserId(withdrawFlow.getUserId());
        userWithdrawDTO.setAmount(withdrawFlow.getAmount());
        userWithdrawDTO.setWithdrawNum(withdrawFlow.getOrderNo());
        userWithdrawDTO.setStatus(withdrawFlow.getState());
        return userWithdrawDTO;
    }

    @Override
    public WithdrawFlow getWithdrawFlowById(Long id) {
        return this.withdrawFlowMapper.getWithdrawFlowById(id);
    }

    @Override
    public BigDecimal getMiniAppUserWithdraw(Long userId, String openId, Byte state) {
        return this.withdrawFlowMapper.getMiniAppUserWithdraw(userId, openId, state);
    }

    @Override
    public WithdrawDTO getWithDrawList(Long userId, BigDecimal drawableCash, BigDecimal withdrawCash) {
        this.logger.debug("\u5f53\u524d\u7528\u6237[{}]\u53ef\u63d0\u73b0\u91d1\u989d\u4e3a[{}]\u5df2\u63d0\u73b0\u91d1\u989d\u4e3a[{}]", new Object[]{userId, drawableCash, withdrawCash});
        WithdrawDTO withdrawDTO = new WithdrawDTO();
        withdrawDTO.setAvailableCash(drawableCash);
        WithdrawFlow withdrawFlow = this.withdrawFlowMapper.getUserLastWithdraw(userId);
        if (withdrawFlow != null && WithdrawEnum.FAIL_PAYMENT.getState().equals(withdrawFlow.getState())) {
            if ("V2_ACCOUNT_SIMPLE_BAN".equals(withdrawFlow.getRemark())) {
                withdrawDTO.setFailMsg("\u60a8\u7684\u5fae\u4fe1\u53f7\u672a\u5b9e\u540d\u8ba4\u8bc1\uff0c\u63d0\u73b0\u5931\u8d25\uff0c\u8bf7\u5b9e\u540d\u8ba4\u8bc1\u540e\u518d\u63d0\u73b0");
            } else {
                withdrawDTO.setFailMsg("\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (BigDecimal.ZERO.compareTo(withdrawCash) == 0) {
            withdrawDTO.setWithdrawConfigDTOList(this.withdrawConfig.getNotWithdrawList());
        } else {
            List<WithdrawConfigDTO> withdrawDtoList = this.copyWithdrawConfigDtoList();
            if (withdrawCash.compareTo(BigDecimal.TEN) >= 0) {
                this.logger.debug("\u5f53\u524d\u7528\u6237[{}]\u76842\u5143\u63d0\u73b0\u589e\u52a0\u9650\u5236", (Object)userId);
                WithdrawConfigDTO withdrawConfigDTO = withdrawDtoList.get(0);
                withdrawConfigDTO.setWithdrawNumber(Integer.valueOf(1));
                if (null == withdrawFlow) {
                    withdrawConfigDTO.setEnableWithdraw(Boolean.valueOf(true));
                } else {
                    List withdrawFlowList = this.withdrawFlowMapper.getUserTodayWithdraw(userId, WithdrawEnum.SUCCESS_PAYMENT.getState(), new BigDecimal(2));
                    if (CollectionUtils.isEmpty((Collection)withdrawFlowList)) {
                        withdrawConfigDTO.setEnableWithdraw(Boolean.valueOf(true));
                    } else {
                        this.logger.debug("\u5f53\u524d\u7528\u6237[{}]\u4eca\u65e5\u5df2\u63d0\u73b0, \u8bbe\u7f6e\u4e3a\u4eca\u65e5\u4e0d\u80fd\u63d0\u73b0");
                        withdrawConfigDTO.setEnableWithdraw(Boolean.valueOf(false));
                    }
                }
            }
            withdrawDTO.setWithdrawConfigDTOList(withdrawDtoList);
        }
        return withdrawDTO;
    }

    private List<WithdrawConfigDTO> copyWithdrawConfigDtoList() {
        ArrayList<WithdrawConfigDTO> withdrawDtoList = new ArrayList<WithdrawConfigDTO>();
        this.withdrawConfig.getHavingWithdrawList().forEach(withdrawConfigDTO -> {
            WithdrawConfigDTO withdrawConfig = new WithdrawConfigDTO();
            BeanUtils.copyProperties((Object)withdrawConfigDTO, (Object)withdrawConfig);
            withdrawDtoList.add(withdrawConfig);
        });
        return withdrawDtoList;
    }
}

