/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.account.impl.context;

import com.bxm.localnews.user.account.impl.callback.IAccountActionCallback;
import com.bxm.localnews.user.enums.AccountActionEnum;
import com.bxm.localnews.user.param.AccountActionParam;
import com.bxm.localnews.user.vo.CashFlow;
import com.bxm.localnews.user.vo.GoldFlow;
import com.bxm.localnews.user.vo.UserAccount;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class AccountActionContext {
    private UserAccount account;
    private UserAccount cloneAccount;
    private IAccountActionCallback callback;
    private final AccountActionParam originParam;
    private Map<Long, GoldFlow> genGoldFlowMap;
    private Map<Long, CashFlow> genCashFlowMap;

    public AccountActionContext(AccountActionParam param) {
        this.originParam = param;
    }

    public void setAccount(UserAccount account) {
        this.account = account;
        this.cloneAccount = new UserAccount();
        this.cloneAccount.setId(account.getId());
        this.cloneAccount.setUserId(account.getUserId());
        this.cloneAccount.setVersion(account.getVersion());
    }

    public void putGoldFlow(Long userId, GoldFlow flow) {
        if (this.genGoldFlowMap == null) {
            this.genGoldFlowMap = Maps.newHashMap();
        }
        this.genGoldFlowMap.put(userId, flow);
    }

    public void putCashFlow(Long userId, CashFlow flow) {
        if (this.genCashFlowMap == null) {
            this.genCashFlowMap = Maps.newHashMap();
        }
        this.genCashFlowMap.put(userId, flow);
    }

    public GoldFlow getGoldFlow(Long userId) {
        if (null != this.genGoldFlowMap) {
            return this.genGoldFlowMap.get(userId);
        }
        return null;
    }

    public CashFlow getCashFlow(Long userId) {
        if (null != this.genCashFlowMap) {
            return this.genCashFlowMap.get(userId);
        }
        return null;
    }

    public Long getUserId() {
        return this.originParam.getUserId();
    }

    public AccountActionEnum getAction() {
        return this.originParam.getAction();
    }

    public Integer getGoldNum() {
        return this.originParam.getGoldNum();
    }

    public BigDecimal getAmount() {
        return this.originParam.getAmount();
    }

    public UserAccount getAccount() {
        return this.account;
    }

    public UserAccount getCloneAccount() {
        return this.cloneAccount;
    }

    public IAccountActionCallback getCallback() {
        return this.callback;
    }

    public void setCallback(IAccountActionCallback callback) {
        this.callback = callback;
    }

    public AccountActionParam getOriginParam() {
        return this.originParam;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.JSON_STYLE);
    }
}

