/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.account.impl.handler.cash;

import com.bxm.localnews.user.account.CashFlowService;
import com.bxm.localnews.user.account.impl.context.AccountActionContext;
import com.bxm.localnews.user.account.impl.handler.AbstractAccountActionHandler;
import com.bxm.localnews.user.exception.UserAccountException;
import com.bxm.localnews.user.vo.CashFlow;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractCashAccountActionHandler
extends AbstractAccountActionHandler {
    @Autowired
    protected CashFlowService cashFlowService;

    @Override
    protected void saveFlow(AccountActionContext context) {
        CashFlow cashFlow = this.buildCashFlow(context);
        if (this.isConvertHandler()) {
            cashFlow.setConvertType(this.support().name());
        }
        this.saveCashFlow(context, cashFlow);
    }

    private CashFlow buildCashFlow(AccountActionContext context) {
        CashFlow cashFlow = new CashFlow();
        cashFlow.setUserId(context.getUserId());
        cashFlow.setAmount(context.getAmount());
        cashFlow.setRelationId(context.getOriginParam().getRelationId());
        cashFlow.setRemark(context.getOriginParam().getRemark());
        if (null != context.getOriginParam().getCashFlowType()) {
            cashFlow.setType(context.getOriginParam().getCashFlowType().name());
        }
        return cashFlow;
    }

    private void saveCashFlow(AccountActionContext context, CashFlow cashFlow) {
        this.cashFlowService.addCashFlow(cashFlow);
        context.putCashFlow(context.getUserId(), cashFlow);
    }

    BigDecimal add(BigDecimal first, BigDecimal second) {
        if (first == null) {
            first = BigDecimal.ZERO;
        }
        if (second == null) {
            second = BigDecimal.ZERO;
        }
        return first.add(second);
    }

    BigDecimal sub(BigDecimal first, BigDecimal second) {
        BigDecimal subtract;
        if (first == null) {
            first = BigDecimal.ZERO;
        }
        if (second == null) {
            second = BigDecimal.ZERO;
        }
        if ((subtract = first.subtract(second)).compareTo(BigDecimal.ZERO) < 0) {
            throw new UserAccountException("\u6263\u9664\u6570\u91cf\u4e0d\u8db3,\u539f\u6570\u503c\uff1a" + first + ",\u6263\u9664\u6570\u503c\uff1a" + second, false);
        }
        return subtract;
    }
}

