/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.attribute.impl;

import com.bxm.localnews.mq.common.constant.UserEventEnum;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.user.attribute.UserAttributeService;
import com.bxm.localnews.user.attribute.UserFollowService;
import com.bxm.localnews.user.attribute.UserFunsService;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.domain.UserFollowMapper;
import com.bxm.localnews.user.domain.UserFunsMapper;
import com.bxm.localnews.user.domain.UserMapper;
import com.bxm.localnews.user.domain.VirtualUserMapper;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.enums.UserFollowStatusEnum;
import com.bxm.localnews.user.integration.MessageUserIntegrationService;
import com.bxm.localnews.user.integration.UserEventIntegrationService;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.param.UserFollowParam;
import com.bxm.localnews.user.properties.NativeUserProperties;
import com.bxm.localnews.user.vo.UserFollow;
import com.bxm.localnews.user.vo.UserFollowRecord;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserFollowServiceImpl
extends BaseService
implements UserFollowService {
    private static final String USER_FOLLOW = "USER_FOLLOW_";
    private static final Long FOLLOW_CACHE_EXPIRED = 1296000L;
    @Resource
    private UserMapper userMapper;
    @Resource
    private UserFollowMapper userFollowMapper;
    @Resource
    private UserFunsMapper userFunsMapper;
    @Resource
    private UserService userService;
    @Resource
    private UserAttributeService userAttributeService;
    @Resource
    private RedisSetAdapter redisSetAdapter;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private DistributedLock distributedLock;
    @Resource
    private UserFunsService userFunsService;
    @Resource
    private MessageUserIntegrationService messageUserIntegrationService;
    @Resource
    private VirtualUserMapper virtualUserMapper;
    @Resource
    private NativeUserProperties nativeUserProperties;
    @Resource
    private UserEventIntegrationService userEventIntegrationService;

    @Override
    public Boolean isFollowed(Long currentUserId, Long targetUserId) {
        KeyGenerator keyGenerator = this.getFollowRedisKey(currentUserId);
        if (!this.redisSetAdapter.hasKey(keyGenerator).booleanValue()) {
            List targetUserIdList = this.userFollowMapper.getFollowedUserIdList(currentUserId);
            if (CollectionUtils.isEmpty((Collection)targetUserIdList)) {
                this.redisSetAdapter.add(keyGenerator, new Object[]{-1L});
                return false;
            }
            this.redisSetAdapter.add(keyGenerator, targetUserIdList.toArray());
        }
        return this.redisSetAdapter.exists(keyGenerator, (Object)targetUserId);
    }

    @Override
    public Boolean hasFollowMsg(Long userId, Long targetUserId) {
        KeyGenerator key = RedisConfig.COMSUME_FOLLOW_INFO.copy().appendKey((Object)userId).appendKey((Object)targetUserId);
        if (this.redisStringAdapter.hasKey(key).booleanValue()) {
            this.redisStringAdapter.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public Boolean follow(Long userId, Long followUserId, Byte type) {
        if (this.notValidUser(userId) || this.notValidUser(followUserId)) {
            return false;
        }
        String requestId = this.nextSequence().toString();
        String lockKey = USER_FOLLOW + userId + "_" + followUserId;
        if (this.distributedLock.lock(lockKey, requestId)) {
            boolean currentFollow = this.isFollowed(userId, followUserId);
            boolean targetFollow = this.isFollowed(followUserId, userId);
            if (UserFollowStatusEnum.FOLLOW.getCode() == type.byteValue() && !currentFollow) {
                if (targetFollow) {
                    this.addFollow(userId, followUserId, UserFollowStatusEnum.EACH_FOLLOW.getCode());
                    this.modifyFollow(followUserId, userId, UserFollowStatusEnum.EACH_FOLLOW.getCode());
                    this.userFunsService.setFuns(userId, followUserId, UserFollowStatusEnum.EACH_FOLLOW.getCode());
                    this.userFunsService.addFuns(followUserId, userId, UserFollowStatusEnum.EACH_FOLLOW.getCode());
                } else {
                    this.addFollow(userId, followUserId, UserFollowStatusEnum.FOLLOW.getCode());
                    this.userFunsService.addFuns(followUserId, userId, UserFollowStatusEnum.FOLLOW.getCode());
                }
                this.userAttributeService.addUserFollowCount(userId, followUserId, true);
                this.messageUserIntegrationService.addFollowMessage(followUserId);
            } else if (UserFollowStatusEnum.UNFOLLOW.getCode() == type.byteValue() && currentFollow) {
                this.userFunsService.removeFuns(followUserId, userId);
                this.removeFollow(userId, followUserId);
                if (targetFollow) {
                    this.modifyFollow(followUserId, userId, UserFollowStatusEnum.FOLLOW.getCode());
                    this.userFunsService.setFuns(userId, followUserId, UserFollowStatusEnum.FOLLOW.getCode());
                }
                this.userAttributeService.addUserFollowCount(userId, followUserId, false);
            }
            this.distributedLock.unlock(lockKey, requestId);
        }
        return true;
    }

    private void addFollow(Long userId, Long followId, byte type) {
        UserFollowRecord follow = new UserFollowRecord();
        follow.setUserId(userId);
        follow.setFollowedUserId(followId);
        follow.setType(Byte.valueOf(type));
        int update = this.userFollowMapper.updateFollowedStatus(follow);
        if (0 == update) {
            follow.setId(Long.valueOf(this.nextId()));
            this.userFollowMapper.insertFollowed(follow);
        }
        this.redisSetAdapter.add(this.getFollowRedisKey(userId), new Object[]{followId});
        PushPayloadInfo userEvent = PushPayloadInfo.build().setType(UserEventEnum.ADD_FOLLOW.type).addExtend("userId", (Object)followId).addExtend("followUserId", (Object)userId).addExtend("followType", (Object)type);
        this.userEventIntegrationService.addUserEvent(userEvent);
        KeyGenerator comsumeKey = RedisConfig.COMSUME_FOLLOW_INFO.copy().appendKey((Object)followId).appendKey((Object)userId);
        this.redisStringAdapter.set(comsumeKey, (Object)"", FOLLOW_CACHE_EXPIRED.longValue());
    }

    private void modifyFollow(Long userId, Long followId, byte type) {
        if (UserFollowStatusEnum.UNFOLLOW.getCode() == type) {
            this.removeFollow(userId, followId);
        } else {
            UserFollowRecord follow = new UserFollowRecord();
            follow.setUserId(userId);
            follow.setFollowedUserId(followId);
            follow.setType(Byte.valueOf(type));
            this.userFollowMapper.updateFollowedStatus(follow);
        }
    }

    private void removeFollow(Long userId, Long followId) {
        UserFollowRecord follow = new UserFollowRecord();
        follow.setUserId(userId);
        follow.setFollowedUserId(followId);
        follow.setType(Byte.valueOf(UserFollowStatusEnum.UNFOLLOW.getCode()));
        this.userFollowMapper.updateFollowedStatus(follow);
        this.redisSetAdapter.remove(this.getFollowRedisKey(userId), new Object[]{followId});
    }

    @Override
    public List<UserFollow> mayInterested(Long userId, String areaCode) {
        List userIdList = this.userMapper.getLikeUserIdListByArea(areaCode);
        if (CollectionUtils.isEmpty((Collection)userIdList)) {
            return null;
        }
        List<Long> resultUserIdList = userIdList.stream().filter(e -> this.isFollowed(userId, (Long)e) == false && !userId.equals(e)).limit(3L).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(resultUserIdList) || resultUserIdList.size() < 3) {
            return null;
        }
        ArrayList<UserFollow> userFollowList = new ArrayList<UserFollow>();
        resultUserIdList.forEach(e -> {
            UserFollow userFollow = new UserFollow();
            userFollow.setUserId(e);
            userFollow.setStatus(Byte.valueOf((byte)1));
            userFollowList.add(userFollow);
        });
        this.fillExtraInfo(userFollowList);
        return userFollowList;
    }

    @Override
    public PageWarper<UserFollow> followList(UserFollowParam param) {
        PageWarper resultPage = new PageWarper(this.userFollowMapper.queryFollowByPage(param));
        this.fillExtraInfo(resultPage.getList());
        return resultPage;
    }

    @Override
    public PageWarper<UserFollow> queryFunsByPage(UserFollowParam param) {
        PageWarper resultPage = new PageWarper(this.userFunsMapper.queryFunsByPage(param));
        this.fillExtraInfo(resultPage.getList());
        return resultPage;
    }

    @Override
    public void virtualFollow(Long userId, Integer num) {
        List virtualUserIdList = this.virtualUserMapper.getRandomVirtualUserIdList(num);
        virtualUserIdList.forEach(e -> this.follow((Long)e, userId, (byte)0));
    }

    private KeyGenerator getFollowRedisKey(Long userId) {
        return RedisConfig.USER_FOLLOW_LIST.copy().appendKey((Object)userId);
    }

    private void fillExtraInfo(List<UserFollow> resultList) {
        if (!CollectionUtils.isEmpty(resultList)) {
            List<UserInfoDTO> userInfoList = this.batchLoadFormCache(resultList);
            resultList.forEach(userFollow -> {
                Optional<UserInfoDTO> userInfoOptional = userInfoList.stream().filter(user -> user.getId().equals(userFollow.getUserId())).findFirst();
                if (userInfoOptional.isPresent()) {
                    UserInfoDTO userInfo = userInfoOptional.get();
                    userFollow.setNickname(userInfo.getNickname());
                    userFollow.setHeadImg(userInfo.getHeadImg());
                    userFollow.setSex(userInfo.getSex());
                    if (userInfo.getIsDefaultPersonalProfile().booleanValue()) {
                        userFollow.setPersonalProfile(this.nativeUserProperties.getDefaultPersonalProfile());
                    } else {
                        userFollow.setPersonalProfile(userInfo.getPersonalProfile());
                    }
                }
            });
        }
    }

    private List<UserInfoDTO> batchLoadFormCache(List<UserFollow> resultList) {
        Set<Long> originUserIds = resultList.stream().map(UserFollow::getUserId).collect(Collectors.toSet());
        return this.userService.getBatchUserInfo(originUserIds);
    }

    private boolean notValidUser(Long userId) {
        UserInfoDTO userInfoDTO = this.userService.getUserFromRedisDB(userId);
        if (null == userInfoDTO) {
            return true;
        }
        return userInfoDTO.getState() != 1 && userInfoDTO.getState() != 3;
    }
}

