/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.attribute.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.common.constant.InfoCombineStateEnum;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.user.attribute.UserPersonalInfoService;
import com.bxm.localnews.user.attribute.UserTagService;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.domain.UserMapper;
import com.bxm.localnews.user.domain.UserTagMapper;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.dto.UserPersonalInfoDTO;
import com.bxm.localnews.user.integration.IMIntegrationService;
import com.bxm.localnews.user.integration.PushMsgIntegrationService;
import com.bxm.localnews.user.integration.UserNewsIntegrationService;
import com.bxm.localnews.user.login.ChuanglanFlashService;
import com.bxm.localnews.user.login.UserAuthService;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.model.PopCache;
import com.bxm.localnews.user.param.ChuangLanLoginParam;
import com.bxm.localnews.user.param.CustomTagParam;
import com.bxm.localnews.user.param.NewbieGuideParam;
import com.bxm.localnews.user.param.UserBirthParam;
import com.bxm.localnews.user.param.UserEmotionParam;
import com.bxm.localnews.user.param.UserHeadImgParam;
import com.bxm.localnews.user.param.UserHomeTownParam;
import com.bxm.localnews.user.param.UserIntroductionParam;
import com.bxm.localnews.user.param.UserJobParam;
import com.bxm.localnews.user.param.UserNicknameParam;
import com.bxm.localnews.user.param.UserPhoneParam;
import com.bxm.localnews.user.param.UserSexParam;
import com.bxm.localnews.user.param.UserSyncParam;
import com.bxm.localnews.user.param.UserTagParam;
import com.bxm.localnews.user.param.UserWechatParam;
import com.bxm.localnews.user.properties.UserProperties;
import com.bxm.localnews.user.support.UserSyncService;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserInfoComplete;
import com.bxm.localnews.user.vo.UserTag;
import com.bxm.localnews.user.vo.UserTagRedis;
import com.bxm.newidea.component.emoji.EmojiCodeParser;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.BitOperatorUtil;
import com.bxm.newidea.component.tools.CharUtil;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.Message;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UserPersonalInfoServiceImpl
extends BaseService
implements UserPersonalInfoService,
ApplicationContextAware {
    private static final String KEY = "PERFECT_INFORMATION_POP";
    private static final String LAST_MODIFY_TIME = "lastModifyTime";
    private static final Pattern WECHAT_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_-]{6,20}$");
    private final UserMapper userMapper;
    private final UserService userService;
    private final UserSyncService userSyncService;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final UserTagService userTagService;
    private final UserTagMapper userTagMapper;
    private final PushMsgIntegrationService pushMsgIntegrationService;
    private final UserNewsIntegrationService userNewsIntegrationService;
    private final UserAuthService userAuthService;
    private final IMIntegrationService imIntegrationService;
    private final ChuanglanFlashService chuanglanFlashService;
    private final UserProperties userProperties;
    private ApplicationContext applicationContext;

    private Message preExecute(Long userId) {
        User user = this.userMapper.selectByPrimaryKey(userId);
        if (null == user) {
            return Message.build((boolean)false, (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (1 != user.getState()) {
            return Message.build((boolean)false, (String)"\u975e\u6b63\u5e38\u72b6\u6001\u7528\u6237\u4e0d\u5141\u8bb8\u8fdb\u884c\u4fe1\u606f\u66f4\u65b0");
        }
        return Message.build((boolean)true).addParam("user", (Object)user);
    }

    private void afterExecute(User user, boolean isRedundancyChange, boolean isTagChange, boolean isPush, List<UserTag> userTagList) {
        if (isTagChange) {
            UserTagRedis userTagRedis = UserTagRedis.buildUserTagRedis((Long)user.getId(), userTagList);
            this.redisHashMapAdapter.put(RedisConfig.USER_TAG, String.valueOf(user.getId()), (Object)JSON.toJSONString((Object)userTagRedis));
        }
        this.userService.putUserToRedis(user);
        this.userService.checkCompleteInfo(user);
        ((UserPersonalInfoService)this.applicationContext.getBean(UserPersonalInfoService.class)).asyncProcessing(user, isRedundancyChange, isPush);
    }

    @Override
    @Async
    public void asyncProcessing(User user, boolean isRedundancyChange, boolean isPush) {
        if (isRedundancyChange) {
            UserSyncParam userSyncParam = new UserSyncParam();
            BeanUtils.copyProperties((Object)user, (Object)userSyncParam);
            this.userSyncService.sync(userSyncParam);
        }
        if (isPush) {
            this.pushMsgIntegrationService.pushUserRecommendInfo(user);
        }
        this.imIntegrationService.syncUser(user.getId());
    }

    @Override
    public Message doUpdateHeadImg(UserHeadImgParam user) {
        int count;
        Message m = this.preExecute(user.getUserId());
        if (!m.isSuccess()) {
            return m;
        }
        User userEntity = (User)m.getParam("user");
        userEntity.setHeadImg(user.getHeadImg());
        long infoCompleteStatus = userEntity.getInfoCompleteState();
        if (BitOperatorUtil.getBitAsBoolean((Long)infoCompleteStatus, (int)InfoCombineStateEnum.HEAD_IMG_COMPLETE.getIndex())) {
            count = this.userMapper.updateUserHeadImg(userEntity.getId(), userEntity.getHeadImg(), null);
        } else {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.HEAD_IMG_COMPLETE.getIndex());
            userEntity.setInfoCompleteState(Long.valueOf(infoCompleteStatus));
            count = this.userMapper.updateUserHeadImg(userEntity.getId(), userEntity.getHeadImg(), Long.valueOf(infoCompleteStatus));
        }
        if (count <= 0) {
            return Message.build((boolean)false);
        }
        this.afterExecute(userEntity, true, false, false, null);
        return Message.build((boolean)true);
    }

    @Override
    public Message doUpdateNickname(UserNicknameParam user) {
        int count;
        Message m = this.preExecute(user.getUserId());
        if (!m.isSuccess()) {
            return m;
        }
        if (this.userNewsIntegrationService.verifySensitiveWord(user.getNickname()).booleanValue()) {
            return Message.build((boolean)false, (String)"\u6635\u79f0\u5305\u542b\u654f\u611f\u8bcd\u6c47");
        }
        User userEntity = (User)m.getParam("user");
        userEntity.setNickname(EmojiCodeParser.replaceSoftbankEmoji((String)user.getNickname()));
        long infoCompleteStatus = userEntity.getInfoCompleteState();
        if (BitOperatorUtil.getBitAsBoolean((Long)infoCompleteStatus, (int)InfoCombineStateEnum.NICKNAME_COMPLETE.getIndex())) {
            count = this.userMapper.updateUserNickname(userEntity.getId(), userEntity.getNickname(), userEntity.getIsTempNickName(), null);
        } else {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.NICKNAME_COMPLETE.getIndex());
            userEntity.setInfoCompleteState(Long.valueOf(infoCompleteStatus));
            count = this.userMapper.updateUserNickname(userEntity.getId(), userEntity.getNickname(), userEntity.getIsTempNickName(), Long.valueOf(infoCompleteStatus));
        }
        if (count > 0) {
            this.afterExecute(userEntity, true, false, false, null);
        }
        return Message.build((boolean)true);
    }

    @Override
    public Message doUpdateBirth(UserBirthParam user) {
        int count;
        Message m = this.preExecute(user.getUserId());
        if (!m.isSuccess()) {
            return m;
        }
        User userEntity = (User)m.getParam("user");
        userEntity.setBirthday(user.getBirthday());
        long infoCompleteStatus = userEntity.getInfoCompleteState();
        if (BitOperatorUtil.getBitAsBoolean((Long)infoCompleteStatus, (int)InfoCombineStateEnum.BIRTHDAY_COMPLETE.getIndex())) {
            count = this.userMapper.updateUserBirth(userEntity.getId(), userEntity.getBirthday(), null);
        } else {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.BIRTHDAY_COMPLETE.getIndex());
            userEntity.setInfoCompleteState(Long.valueOf(infoCompleteStatus));
            count = this.userMapper.updateUserBirth(userEntity.getId(), userEntity.getBirthday(), Long.valueOf(infoCompleteStatus));
        }
        if (count > 0) {
            this.afterExecute(userEntity, false, false, true, null);
        }
        return Message.build((boolean)true);
    }

    @Override
    public Message doUpdateHometown(UserHomeTownParam user) {
        int count;
        Message m = this.preExecute(user.getUserId());
        if (!m.isSuccess()) {
            return m;
        }
        User userEntity = (User)m.getParam("user");
        userEntity.setHometownCode(user.getHometownCode());
        userEntity.setHometownName(user.getHometownName());
        long infoCompleteStatus = userEntity.getInfoCompleteState();
        if (BitOperatorUtil.getBitAsBoolean((Long)infoCompleteStatus, (int)InfoCombineStateEnum.HOMETOWN_COMPLETE.getIndex())) {
            count = this.userMapper.updateUserHometown(userEntity.getId(), userEntity.getHometownCode(), userEntity.getHometownName(), null);
        } else {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.HOMETOWN_COMPLETE.getIndex());
            userEntity.setInfoCompleteState(Long.valueOf(infoCompleteStatus));
            count = this.userMapper.updateUserHometown(userEntity.getId(), userEntity.getHometownCode(), userEntity.getHometownName(), Long.valueOf(infoCompleteStatus));
        }
        if (count > 0) {
            this.afterExecute(userEntity, false, false, true, null);
        }
        return Message.build((boolean)true);
    }

    @Override
    public Message doUpdateEmotion(UserEmotionParam user) {
        int count;
        Message m = this.preExecute(user.getUserId());
        if (!m.isSuccess()) {
            return m;
        }
        User userEntity = (User)m.getParam("user");
        userEntity.setRelationshipStatus(user.getRelationshipStatus());
        long infoCompleteStatus = userEntity.getInfoCompleteState();
        if (BitOperatorUtil.getBitAsBoolean((Long)infoCompleteStatus, (int)InfoCombineStateEnum.RELATION_SHIP_COMPLETE.getIndex())) {
            count = this.userMapper.updateUserRelationshipStatus(userEntity.getId(), userEntity.getRelationshipStatus(), null);
        } else {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.RELATION_SHIP_COMPLETE.getIndex());
            userEntity.setInfoCompleteState(Long.valueOf(infoCompleteStatus));
            count = this.userMapper.updateUserRelationshipStatus(userEntity.getId(), userEntity.getRelationshipStatus(), Long.valueOf(infoCompleteStatus));
        }
        if (count > 0) {
            this.afterExecute(userEntity, false, false, false, null);
        }
        return Message.build((boolean)true);
    }

    @Override
    public Message doUpdateJob(UserJobParam user) {
        int count;
        this.logger.debug("\u66f4\u65b0\u804c\u4e1a,\u53c2\u6570\u4e3a:[{}]", JSONObject.toJSON((Object)user));
        Message m = this.preExecute(user.getUserId());
        if (!m.isSuccess()) {
            return m;
        }
        User userEntity = (User)m.getParam("user");
        userEntity.setCompany(user.getCompany());
        userEntity.setJobTitle(user.getJobTitle());
        userEntity.setJobCategory(user.getJobCategory());
        userEntity.setJobCategoryName(user.getJobCategoryName());
        userEntity.setJobType(user.getJobType());
        userEntity.setJobTypeName(user.getJobTypeName());
        long infoCompleteStatus = userEntity.getInfoCompleteState();
        if (BitOperatorUtil.getBitAsBoolean((Long)infoCompleteStatus, (int)InfoCombineStateEnum.JOB_COMPLETE.getIndex())) {
            count = this.userMapper.updateUserJob(userEntity.getId(), userEntity.getJobType(), userEntity.getJobTypeName(), userEntity.getJobCategoryName(), userEntity.getJobCategory(), userEntity.getCompany(), userEntity.getJobTitle(), null);
        } else {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.JOB_COMPLETE.getIndex());
            userEntity.setInfoCompleteState(Long.valueOf(infoCompleteStatus));
            count = this.userMapper.updateUserJob(userEntity.getId(), userEntity.getJobType(), userEntity.getJobTypeName(), userEntity.getJobCategoryName(), userEntity.getJobCategory(), userEntity.getCompany(), userEntity.getJobTitle(), Long.valueOf(infoCompleteStatus));
        }
        if (count > 0) {
            this.afterExecute(userEntity, false, false, true, null);
        }
        return Message.build((boolean)true);
    }

    @Override
    public Message doUpdatePersonalProfile(UserIntroductionParam user) {
        int count;
        if (this.userNewsIntegrationService.verifySensitiveWord(user.getPersonalProfile()).booleanValue()) {
            return Message.build((boolean)false, (String)"\u4e2a\u4eba\u7b80\u4ecb\u542b\u6709\u654f\u611f\u8bcd\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        Message m = this.preExecute(user.getUserId());
        if (!m.isSuccess()) {
            return m;
        }
        User userEntity = (User)m.getParam("user");
        userEntity.setPersonalProfile(user.getPersonalProfile());
        long infoCompleteStatus = userEntity.getInfoCompleteState();
        if (BitOperatorUtil.getBitAsBoolean((Long)infoCompleteStatus, (int)InfoCombineStateEnum.PERSONAL_PROFILE_COMPLETE.getIndex())) {
            count = this.userMapper.updateUserPersonalProfile(userEntity.getId(), userEntity.getPersonalProfile(), null);
        } else {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.PERSONAL_PROFILE_COMPLETE.getIndex());
            userEntity.setInfoCompleteState(Long.valueOf(infoCompleteStatus));
            count = this.userMapper.updateUserPersonalProfile(userEntity.getId(), userEntity.getPersonalProfile(), Long.valueOf(infoCompleteStatus));
        }
        if (count > 0) {
            this.afterExecute(userEntity, false, false, false, null);
        }
        return Message.build((boolean)true);
    }

    @Override
    public Message doUpdateUserPhone(UserPhoneParam user) {
        int count;
        this.logger.debug("\u66f4\u6362\u624b\u673a\u53f7:[{}]", JSONObject.toJSON((Object)user));
        Message validMessage = this.validPhoneProxy(user);
        if (!validMessage.isSuccess()) {
            return validMessage;
        }
        String phone = (String)validMessage.getParam("phone");
        Message m = this.preExecute(user.getUserId());
        if (!m.isSuccess()) {
            return m;
        }
        User userEntity = (User)m.getParam("user");
        if (com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)userEntity.getPhone())) {
            if (phone.equals(userEntity.getPhone())) {
                return Message.build((boolean)true).addParam("phone", (Object)phone);
            }
            return Message.build((boolean)false, (String)"\u5df2\u7ed1\u5b9a\u5176\u4ed6\u624b\u673a\u53f7\uff0c\u8bf7\u91cd\u65b0\u767b\u9646").addParam("code", (Object)RespCode.UNAUTHORIZED);
        }
        Message messageByCheckAuth = this.userAuthService.checkBindExist((byte)1, phone);
        if (!messageByCheckAuth.isSuccess()) {
            return messageByCheckAuth;
        }
        userEntity.setPhone(phone);
        long infoCompleteStatus = userEntity.getInfoCompleteState();
        if (BitOperatorUtil.getBitAsBoolean((Long)infoCompleteStatus, (int)InfoCombineStateEnum.PHONE_COMPLETE.getIndex())) {
            count = this.userMapper.updateUserPhone(userEntity.getId(), phone, null);
        } else {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.PHONE_COMPLETE.getIndex());
            userEntity.setInfoCompleteState(Long.valueOf(infoCompleteStatus));
            count = this.userMapper.updateUserPhone(userEntity.getId(), phone, Long.valueOf(infoCompleteStatus));
        }
        if (count > 0) {
            this.userAuthService.addUserAuth((byte)1, user.getUserId(), phone, null);
            this.userService.isRisk(user.getUserId(), phone, (BasicParam)user, user.getDeviceToken(), user.getIp());
            this.afterExecute(userEntity, false, false, false, null);
        }
        return Message.build((boolean)true).addParam("phone", (Object)phone);
    }

    private Message validPhoneProxy(UserPhoneParam userPhoneParam) {
        if (com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)userPhoneParam.getFlashToken())) {
            return this.validPhoneByFlashToken(userPhoneParam);
        }
        if (com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)userPhoneParam.getPhone()) && com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)userPhoneParam.getCode())) {
            return this.validPhoneByCode(userPhoneParam);
        }
        return Message.build((boolean)false, (String)"\u53c2\u6570\u9519\u8bef");
    }

    private Message validPhoneByFlashToken(UserPhoneParam userPhoneParam) {
        ChuangLanLoginParam chuangLanLoginParam = new ChuangLanLoginParam();
        BeanUtils.copyProperties((Object)userPhoneParam, (Object)chuangLanLoginParam);
        String phone = this.chuanglanFlashService.getPhone(chuangLanLoginParam);
        if (null == phone) {
            this.logger.error("\u4e00\u952e\u767b\u5f55\u83b7\u53d6\u624b\u673a\u53f7\u7801\u5931\u8d25\uff0c\u53c2\u6570\uff1a[{}]", (Object)chuangLanLoginParam);
            return Message.build((boolean)false, (String)"\u83b7\u53d6\u624b\u673a\u53f7\u5931\u8d25");
        }
        return Message.build((boolean)true).addParam("phone", (Object)phone);
    }

    private Message validPhoneByCode(UserPhoneParam userPhoneParam) {
        return Message.build((boolean)true).addParam("phone", (Object)userPhoneParam.getPhone());
    }

    @Override
    public Message doUpdateUserSex(UserSexParam user) {
        int count;
        Message m = this.preExecute(user.getUserId());
        if (!m.isSuccess()) {
            return m;
        }
        if (null == user.getSex() || 0 == user.getSex()) {
            return Message.build((boolean)true);
        }
        User userEntity = (User)m.getParam("user");
        userEntity.setSex(user.getSex());
        long infoCompleteStatus = userEntity.getInfoCompleteState();
        if (BitOperatorUtil.getBitAsBoolean((Long)infoCompleteStatus, (int)InfoCombineStateEnum.SEX_COMPLETE.getIndex())) {
            count = this.userMapper.updateUserSex(userEntity.getId(), userEntity.getSex(), null);
        } else {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.SEX_COMPLETE.getIndex());
            userEntity.setInfoCompleteState(Long.valueOf(infoCompleteStatus));
            count = this.userMapper.updateUserSex(userEntity.getId(), userEntity.getSex(), Long.valueOf(infoCompleteStatus));
        }
        if (count > 0) {
            this.afterExecute(userEntity, true, false, true, null);
        }
        return Message.build((boolean)true);
    }

    @Override
    public Message doUpdateUserWechat(UserWechatParam user) {
        int count;
        Message m = this.preExecute(user.getUserId());
        if (!m.isSuccess()) {
            return m;
        }
        Message isValid = this.validWechat(user.getWechatId());
        if (!isValid.isSuccess()) {
            return isValid;
        }
        User userEntity = (User)m.getParam("user");
        userEntity.setWechatId(user.getWechatId());
        long infoCompleteStatus = userEntity.getInfoCompleteState();
        if (BitOperatorUtil.getBitAsBoolean((Long)infoCompleteStatus, (int)InfoCombineStateEnum.WECHAT_COMPLETE.getIndex())) {
            count = this.userMapper.updateUserWechat(userEntity.getId(), userEntity.getWechatId(), null);
        } else {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.WECHAT_COMPLETE.getIndex());
            userEntity.setInfoCompleteState(Long.valueOf(infoCompleteStatus));
            count = this.userMapper.updateUserWechat(userEntity.getId(), userEntity.getWechatId(), Long.valueOf(infoCompleteStatus));
        }
        if (count > 0) {
            this.afterExecute(userEntity, true, false, true, null);
        }
        return Message.build((boolean)true);
    }

    private Message validWechat(String qqorwx) {
        if (com.bxm.newidea.component.tools.StringUtils.isEmpty((CharSequence)qqorwx) || qqorwx.length() < 6 || qqorwx.length() > 20) {
            return Message.build((boolean)false, (String)"\u8bf7\u8f93\u51656-20\u4e2a\u5b57\u7b26\uff0c\u652f\u6301\u5b57\u6bcd\uff0c\u6570\u5b57\uff0c\u4e0b\u5212\u7ebf\u548c\u51cf\u53f7");
        }
        Matcher m = WECHAT_NAME_PATTERN.matcher(qqorwx);
        boolean isValid = m.matches();
        if (!isValid) {
            return Message.build((boolean)false, (String)"\u8bf7\u4e0d\u8981\u8f93\u5165\u4e2d\u6587\u548c\u5176\u4ed6\u7279\u6b8a\u7b26\u53f7");
        }
        return Message.build((boolean)true);
    }

    @Override
    public Message doUpdateNewbieGuideInfo(NewbieGuideParam newbieGuideParam) {
        Message m = this.preExecute(newbieGuideParam.getUserId());
        if (!m.isSuccess()) {
            return m;
        }
        Message isValid = this.validNewbieGuideInfo(newbieGuideParam);
        if (!isValid.isSuccess()) {
            return isValid;
        }
        User userEntity = (User)m.getParam("user");
        BeanUtils.copyProperties((Object)newbieGuideParam, (Object)userEntity);
        long infoCompleteStatus = this.initUserInfoCompleteStatus(userEntity);
        userEntity.setInfoCompleteState(Long.valueOf(infoCompleteStatus));
        int count = this.userMapper.updateNewbieGuideInfo(userEntity);
        if (count > 0) {
            this.afterExecute(userEntity, false, false, true, null);
        }
        return Message.build((boolean)true).addParam("user", (Object)this.userService.convertUserToDTO(userEntity));
    }

    private Message validNewbieGuideInfo(NewbieGuideParam newbieGuideParam) {
        if (com.bxm.newidea.component.tools.StringUtils.isBlank((CharSequence)newbieGuideParam.getNickname())) {
            return Message.build((boolean)false, (String)"\u8bf7\u5b8c\u5584\u6635\u79f0\uff0c\u4f7f\u7528\u771f\u5b9e\u6635\u79f0\uff0c\u65b9\u4fbf\u5927\u5bb6\u8ba4\u8bc6\u4f60");
        }
        if (com.bxm.newidea.component.tools.StringUtils.isBlank((CharSequence)newbieGuideParam.getHeadImg())) {
            return Message.build((boolean)false, (String)"\u8bf7\u5b8c\u5584\u5934\u50cf\uff0c\u4f7f\u7528\u771f\u5b9e\u5934\u50cf\uff0c\u65b9\u4fbf\u5927\u5bb6\u8ba4\u8bc6\u4f60");
        }
        if (null == newbieGuideParam.getSex()) {
            return Message.build((boolean)false, (String)"\u8bf7\u9009\u62e9\u6027\u522b");
        }
        if (null == newbieGuideParam.getBirthday()) {
            return Message.build((boolean)false, (String)"\u8bf7\u586b\u5199\u751f\u65e5\uff0c\u53ef\u4ee5\u627e\u5230\u66f4\u591a\u540c\u9f84\u4eba\u54e6");
        }
        return Message.build((boolean)true);
    }

    @Override
    public Message doUpdateUserTag(UserTagParam user) {
        this.logger.debug("\u66f4\u65b0\u7528\u6237\u6807\u7b7e\u4fe1\u606f\uff1a[{}]", JSONObject.toJSON((Object)user));
        Message m = this.preExecute(user.getUserId());
        if (!m.isSuccess()) {
            return m;
        }
        long count = user.getSpecificUserTagParamList().parallelStream().filter(e -> e.getChooseFlag() != 0).count();
        if (count > 15L) {
            return Message.build((boolean)false, (String)"\u6807\u7b7e\u9009\u62e9\u4e2a\u6570\u9650\u5b9a15\u4e2a");
        }
        User userEntity = (User)m.getParam("user");
        ArrayList<UserTag> userTagList = new ArrayList<UserTag>();
        Date date = new Date();
        int index = 0;
        for (UserTagParam.SpecificUserTagParam specificUserTagParam : user.getSpecificUserTagParamList()) {
            if (0 == specificUserTagParam.getChooseFlag() && 1 == specificUserTagParam.getDefaultFlag()) continue;
            UserTag userTag = UserTag.builder().createTime(date).id(this.nextSequence()).label(specificUserTagParam.getLabel()).order(Integer.valueOf(index)).defaultFlag(specificUserTagParam.getDefaultFlag()).userId(user.getUserId()).deleteFlag(Byte.valueOf((byte)0)).build();
            if (0 == specificUserTagParam.getChooseFlag() && 0 == specificUserTagParam.getDefaultFlag()) {
                userTag.setDeleteFlag(Byte.valueOf((byte)1));
                userTag.setDeleteTime(date);
            }
            userTagList.add(userTag);
            ++index;
        }
        this.userTagMapper.deleteByUserId(user.getUserId());
        MybatisBatchBuilder.create(UserTagMapper.class, userTagList).run(UserTagMapper::insert);
        long infoCompleteStatus = userEntity.getInfoCompleteState();
        infoCompleteStatus = !CollectionUtils.isEmpty((Collection)user.getSpecificUserTagParamList()) ? BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.USER_TAG_COMPLETE.getIndex()) : BitOperatorUtil.clearBit((Long)infoCompleteStatus, (int)InfoCombineStateEnum.USER_TAG_COMPLETE.getIndex());
        userEntity.setInfoCompleteState(Long.valueOf(infoCompleteStatus));
        this.userMapper.updateUserInfoCompleteStatus(new UserInfoComplete(user.getUserId(), Long.valueOf(infoCompleteStatus)));
        this.afterExecute(userEntity, false, true, false, userTagList);
        return Message.build((boolean)true);
    }

    @Override
    public UserPersonalInfoDTO getUserPersonalInfo(Long userId) {
        UserInfoDTO dto = this.userService.getUserFromRedisDB(userId);
        if (null == dto) {
            return null;
        }
        int infoCompletePercent = InfoCombineStateEnum.getInfoCompletePercent((Long)(dto.getInfoCompleteState() == null ? 0L : dto.getInfoCompleteState()));
        String infoCompleteTaskText = this.userProperties.getInfoCompleteTaskText();
        List<UserTag> userTagList = this.userTagService.getUserTagFromRedisDb(userId);
        UserPersonalInfoDTO userPersonalInfoDTO = this.convertUserInfo2UserPersonalInfo(dto);
        userPersonalInfoDTO.setInfoCompletePercent(Integer.valueOf(infoCompletePercent));
        userPersonalInfoDTO.setInfoCompleteTaskText(infoCompleteTaskText);
        userPersonalInfoDTO.setUserTagList(userTagList.stream().filter(e -> e.getDeleteFlag() == 0).map(UserTag::getLabel).collect(Collectors.toList()));
        return userPersonalInfoDTO;
    }

    private UserPersonalInfoDTO convertUserInfo2UserPersonalInfo(UserInfoDTO dto) {
        UserPersonalInfoDTO.IndustryInfo industryInfo = null;
        if (null != dto.getIndustry()) {
            industryInfo = UserPersonalInfoDTO.IndustryInfo.builder().company(dto.getCompany()).jobCategory(dto.getJobCategory()).jobCategoryName(dto.getJobCategoryName()).jobTitle(dto.getJobTitle()).jobType(dto.getJobType()).jobTypeName(dto.getJobTypeName()).build();
        }
        return UserPersonalInfoDTO.builder().personalProfile(dto.getPersonalProfile()).isDefaultPersonalProfile(dto.getIsDefaultPersonalProfile()).birthday(dto.getBirthday()).headImg(dto.getHeadImg()).industryInfo(industryInfo).industry(dto.getIndustry()).newbieGuideFlag(dto.getNewbieGuideFlag()).isTempNickName(Byte.valueOf((byte)1)).generation(this.getGeneration(dto)).nickname(dto.getNickname()).phone(dto.getPhone()).id(dto.getId()).relationshipStatus(dto.getRelationshipStatus()).sex(dto.getSex()).wechatId(dto.getWechatId()).hometownCode(dto.getHometownCode()).hometownName(dto.getHometownName()).build();
    }

    @Override
    public Long initUserInfoCompleteStatus(User user) {
        List<UserTag> userTagList;
        long infoCompleteStatus = 0L;
        if (null != user.getSex() && 0 != user.getSex()) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.SEX_COMPLETE.getIndex());
        }
        if (com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)user.getNickname())) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.NICKNAME_COMPLETE.getIndex());
        }
        if (com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)user.getHeadImg())) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.HEAD_IMG_COMPLETE.getIndex());
        }
        if (null != user.getBirthday()) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.BIRTHDAY_COMPLETE.getIndex());
        }
        if (null != user.getRelationshipStatus()) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.RELATION_SHIP_COMPLETE.getIndex());
        }
        if (com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)user.getHometownCode())) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.HOMETOWN_COMPLETE.getIndex());
        }
        if (null != user.getJobCategory()) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.JOB_COMPLETE.getIndex());
        }
        if (com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)user.getPersonalProfile())) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.PERSONAL_PROFILE_COMPLETE.getIndex());
        }
        if (com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)user.getPhone())) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.PHONE_COMPLETE.getIndex());
        }
        if (com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)user.getWechatId())) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.WECHAT_COMPLETE.getIndex());
        }
        if (!CollectionUtils.isEmpty(userTagList = this.userTagService.getUserTagFromRedisDb(user.getId()))) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.USER_TAG_COMPLETE.getIndex());
        }
        return infoCompleteStatus;
    }

    @Override
    public Boolean checkInfoCompleteStatus(Long userId) {
        User user;
        UserInfoDTO dto = this.userService.getUserFromRedisDB(userId);
        Long infoCompleteStatus = dto.getInfoCompleteState();
        if (null == infoCompleteStatus && null == (infoCompleteStatus = (user = this.userMapper.selectByPrimaryKey(userId)).getInfoCompleteState())) {
            return false;
        }
        int completeCount = InfoCombineStateEnum.getInfoCompleteStatus((Long)infoCompleteStatus);
        return 10 - completeCount < 2;
    }

    @Override
    public Message saveCustomTag(CustomTagParam customTagParam) {
        if (CharUtil.getWordCount((String)customTagParam.getLabel()) > 10) {
            return Message.build((boolean)false, (String)"\u6807\u7b7e\u8d85\u8fc75\u4e2a\u957f\u5ea6");
        }
        if (this.userNewsIntegrationService.verifySensitiveWord(customTagParam.getLabel()).booleanValue()) {
            return Message.build((boolean)false, (String)"\u6807\u7b7e\u542b\u6709\u654f\u611f\u8bcd\u8bcd\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        Message m = this.preExecute(customTagParam.getUserId());
        if (!m.isSuccess()) {
            return m;
        }
        User userEntity = (User)m.getParam("user");
        List<UserTag> userTagList = this.userTagService.getUserTagFromRedisDb(customTagParam.getUserId());
        long count = userTagList.stream().filter(e -> 0 == e.getDeleteFlag()).count();
        if (count >= 15L) {
            return Message.build((boolean)false, (String)"\u6807\u7b7e\u4e0d\u80fd\u8d85\u8fc715\u4e2a\u54e6");
        }
        int minOder = 0;
        if (!CollectionUtils.isEmpty(userTagList)) {
            minOder = userTagList.get(0).getOrder();
        } else {
            userTagList = new ArrayList<UserTag>();
        }
        UserTag userTag = UserTag.buildUserTag((Long)customTagParam.getUserId(), (Integer)(minOder - 1), (String)customTagParam.getLabel(), (Long)this.nextSequence());
        this.userTagMapper.insert(userTag);
        userTagList.add(0, userTag);
        long infoCompleteStatus = userEntity.getInfoCompleteState();
        if (!BitOperatorUtil.getBitAsBoolean((Long)infoCompleteStatus, (int)InfoCombineStateEnum.USER_TAG_COMPLETE.getIndex())) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.USER_TAG_COMPLETE.getIndex());
            userEntity.setInfoCompleteState(Long.valueOf(infoCompleteStatus));
            this.userMapper.updateUserInfoCompleteStatus(new UserInfoComplete(customTagParam.getUserId(), Long.valueOf(infoCompleteStatus)));
        }
        this.afterExecute(userEntity, false, true, false, userTagList);
        return Message.build((boolean)true).addParam("tag", (Object)this.userTagService.convertUserTag2UserTagDto(userTag));
    }

    @Override
    public Boolean getCompleteInformationWindow(Long userId) {
        this.logger.debug("\u83b7\u53d6\u7528\u6237\u5b8c\u5584\u4e2a\u4eba\u8d44\u6599\u5f39\u7a97\uff0cuserId:[{}]", (Object)userId);
        UserService userService = (UserService)SpringContextHolder.getBean(UserService.class);
        UserInfoDTO userFromRedisDB = userService.getUserFromRedisDB(userId);
        int status = InfoCombineStateEnum.getInfoUnCompleteStatus((Long)userFromRedisDB.getInfoCompleteState());
        if (status >= 2) {
            KeyGenerator cacheKey = RedisConfig.USER_CACHE_POPUP.copy().appendKey((Object)userId);
            Map cacheMap = this.redisHashMapAdapter.entries(cacheKey, PopCache.class);
            PopCache popCache = (PopCache)cacheMap.get(KEY);
            if (Objects.isNull(popCache)) {
                popCache = new PopCache();
            }
            Long popTime = (Long)popCache.getParam(LAST_MODIFY_TIME);
            long timeMillis = System.currentTimeMillis();
            if (popTime == null || timeMillis - popTime > 604800000L) {
                popCache.setPopUp(Boolean.TRUE.booleanValue());
                popCache.addParam(LAST_MODIFY_TIME, (Object)System.currentTimeMillis());
                Integer num = (Integer)popCache.getParam("num");
                num = Objects.isNull(num) ? Integer.valueOf(1) : Integer.valueOf(num + 1);
                popCache.addParam("num", (Object)num);
                this.redisHashMapAdapter.put(cacheKey, KEY, (Object)popCache);
                this.logger.debug("\u5f39\u51fa\u4e2a\u4eba\u8d44\u6599\u5f15\u5bfc\u5f39\u7a97:[{}]", (Object)JSONObject.toJSONString((Object)popCache));
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    private String getGeneration(UserInfoDTO user) {
        LocalDate birthday;
        String gen;
        String generationStr = "";
        if (null != user.getBirthday() && !StringUtils.isEmpty((Object)(gen = this.userService.getGeneration(birthday = user.getBirthday().toInstant().atZone(ZoneId.systemDefault()).toLocalDate())))) {
            generationStr = gen;
        }
        return generationStr;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Autowired
    public UserPersonalInfoServiceImpl(UserMapper userMapper, UserService userService, UserSyncService userSyncService, RedisHashMapAdapter redisHashMapAdapter, UserTagService userTagService, UserTagMapper userTagMapper, PushMsgIntegrationService pushMsgIntegrationService, UserNewsIntegrationService userNewsIntegrationService, UserAuthService userAuthService, IMIntegrationService imIntegrationService, ChuanglanFlashService chuanglanFlashService, UserProperties userProperties, ApplicationContext applicationContext) {
        this.userMapper = userMapper;
        this.userService = userService;
        this.userSyncService = userSyncService;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.userTagService = userTagService;
        this.userTagMapper = userTagMapper;
        this.pushMsgIntegrationService = pushMsgIntegrationService;
        this.userNewsIntegrationService = userNewsIntegrationService;
        this.userAuthService = userAuthService;
        this.imIntegrationService = imIntegrationService;
        this.chuanglanFlashService = chuanglanFlashService;
        this.userProperties = userProperties;
        this.applicationContext = applicationContext;
    }
}

