/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.login.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.auth.enums.AuthCodeEnum;
import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.param.PointReportParam;
import com.bxm.localnews.common.rediskey.UserRedisKey;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.account.CashFlowService;
import com.bxm.localnews.user.account.UserAccountService;
import com.bxm.localnews.user.attribute.UserPersonalInfoService;
import com.bxm.localnews.user.auth.UserAuthCodeService;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.domain.UserAuthMapper;
import com.bxm.localnews.user.domain.UserEquipmentMapper;
import com.bxm.localnews.user.domain.UserMapper;
import com.bxm.localnews.user.dto.EquipmentDTO;
import com.bxm.localnews.user.dto.LocationUserInfoDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.dto.h5.ClientVersionDto;
import com.bxm.localnews.user.enums.AwardTypeEnum;
import com.bxm.localnews.user.enums.CashEnum;
import com.bxm.localnews.user.enums.CashFlowConvertTypeEnum;
import com.bxm.localnews.user.enums.CashFlowTypeEnum;
import com.bxm.localnews.user.enums.InviteRecordStateEnum;
import com.bxm.localnews.user.exception.UserRepeatCreateException;
import com.bxm.localnews.user.integration.AppVersionIntegrationService;
import com.bxm.localnews.user.integration.BizIntegrationService;
import com.bxm.localnews.user.integration.BizLogIntegrationService;
import com.bxm.localnews.user.integration.IMIntegrationService;
import com.bxm.localnews.user.integration.PushMsgIntegrationService;
import com.bxm.localnews.user.integration.SmsIntegrationService;
import com.bxm.localnews.user.integration.UserNewsIntegrationService;
import com.bxm.localnews.user.invite.InviteRecordService;
import com.bxm.localnews.user.login.LoginService;
import com.bxm.localnews.user.login.UserAuthService;
import com.bxm.localnews.user.login.UserLoginHistoryService;
import com.bxm.localnews.user.login.UserParamCheckService;
import com.bxm.localnews.user.login.UserRegistrationService;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.param.AccountCashParam;
import com.bxm.localnews.user.support.ChannelService;
import com.bxm.localnews.user.support.UserEquipmentService;
import com.bxm.localnews.user.support.UserSyncService;
import com.bxm.localnews.user.timer.InviteRelationshipTask;
import com.bxm.localnews.user.vo.ImChatroom;
import com.bxm.localnews.user.vo.InviteRecord;
import com.bxm.localnews.user.vo.LoginInfo;
import com.bxm.localnews.user.vo.LoginMeta;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserAccount;
import com.bxm.localnews.user.vo.UserAuth;
import com.bxm.localnews.user.vo.UserEquipment;
import com.bxm.newidea.component.jwt.tools.JwtTokenUtil;
import com.bxm.newidea.component.log.LogMarker;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.schedule.ScheduleService;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.retry.RetryException;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="loginService")
@RefreshScope
public class LoginServiceImpl
extends BaseService
implements LoginService {
    private final SmsIntegrationService smsIntegrationService;
    private final UserAuthMapper userAuthMapper;
    private final UserMapper userMapper;
    private final UserService userService;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final RedisStringAdapter redisStringAdapter;
    private final AppVersionIntegrationService appVersionIntegrationService;
    private final UserAuthService userAuthService;
    private final BizLogIntegrationService bizLogIntegrationService;
    private final UserLoginHistoryService userLoginHistoryService;
    private final UserNewsIntegrationService userNewsIntegrationService;
    private final UserSyncService userSyncService;
    private final InviteRecordService inviteRecordService;
    private final UserAccountService userAccountService;
    private final CashFlowService cashFlowService;
    private final UserEquipmentService userEquipmentService;
    private final ChannelService channelService;
    private final BizIntegrationService bizIntegrationService;
    private final UserParamCheckService userParamCheckService;
    private final UserEquipmentMapper userEquipmentMapper;
    private final UserRegistrationService userRegistrationService;
    private final UserAuthCodeService userAuthCodeService;
    private final ScheduleService scheduleService;
    private final PushMsgIntegrationService pushMsgIntegrationService;
    private final IMIntegrationService imIntegrationService;

    @Override
    @Retryable(value={RetryException.class}, backoff=@Backoff(value=300L))
    public Message doLogin(LoginInfo loginInfo, BasicParam basicParam) {
        Message message;
        UserAuth userAuth = this.userAuthMapper.selectByUserAuth(loginInfo.getType(), loginInfo.getLoginName());
        try {
            message = this.preJudgeBeforeLogin(loginInfo, basicParam, userAuth);
        }
        catch (UserRepeatCreateException e) {
            this.logger.warn("\u91cd\u590d\u521b\u5efa\u7528\u6237\uff0c\u8fdb\u884c\u91cd\u8bd5\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)loginInfo);
            throw new RetryException("\u7528\u6237\u5df2\u5b58\u5728\uff0c\u91cd\u65b0\u521b\u5efa");
        }
        if (!message.isSuccess()) {
            return message;
        }
        Boolean isReturn = (Boolean)message.getParam("return");
        if (null != isReturn && isReturn.booleanValue()) {
            return message;
        }
        LoginMeta meta = this.login(userAuth, loginInfo, basicParam);
        if (meta.getUser() != null) {
            this.bizLogIntegrationService.login(meta.getUser().getId(), Integer.valueOf(basicParam.getPlatform()));
        }
        return Message.build((boolean)true).addParam("meta", (Object)meta);
    }

    private Message preJudgeBeforeLogin(LoginInfo loginInfo, BasicParam basicParam, UserAuth userAuth) throws UserRepeatCreateException {
        boolean isPublishState = this.appVersionIntegrationService.getPublishState(basicParam);
        if (1 != loginInfo.getType()) {
            if (null == userAuth) {
                if (!isPublishState) {
                    Message meta = this.registerByWechat(loginInfo, basicParam);
                    return meta.addParam("return", (Object)true);
                }
                LoginMeta meta = new LoginMeta();
                meta.setCode(512);
                return Message.build((boolean)true).addParam("meta", (Object)meta).addParam("return", (Object)true);
            }
        } else if (1 == loginInfo.getType()) {
            Message message;
            if (isPublishState && this.appVersionIntegrationService.inWhiteList(loginInfo.getLoginName()).booleanValue()) {
                loginInfo.setCode("123456");
            }
            if (!this.userParamCheckService.checkParam(loginInfo)) {
                this.logger.info("doLogin failed:" + loginInfo);
                return Message.build((boolean)false, (String)"\u53c2\u6570\u9519\u8bef");
            }
            if (isPublishState && this.userParamCheckService.checkVerifyPwd(loginInfo) && !(message = this.userParamCheckService.verifyPwd(loginInfo.getPassword(), userAuth)).isSuccess()) {
                return message;
            }
        }
        return Message.build((boolean)true);
    }

    private Message registerByWechat(LoginInfo loginInfo, BasicParam basicParam) throws UserRepeatCreateException {
        User user = this.getUserByType(loginInfo);
        Message messageByCheckUser = this.userParamCheckService.checkRepeatBind(user, loginInfo);
        if (!messageByCheckUser.isSuccess()) {
            return messageByCheckUser;
        }
        LoginMeta meta = this.createAndBinding(user, loginInfo, basicParam);
        return Message.build((boolean)true).addParam("meta", (Object)meta);
    }

    private LoginMeta login(UserAuth userAuth, LoginInfo loginInfo, BasicParam basicParam) {
        Message deviceExistMessage = this.userLoginHistoryService.isDeviceExist(userAuth.getUserId(), basicParam.getDevcId());
        String equipment = deviceExistMessage.getParamMap().get("equipment") == null ? null : deviceExistMessage.getParamMap().get("equipment").toString();
        User user = this.userMapper.selectByPrimaryKey(userAuth.getUserId());
        this.addWechatLoginInfo(loginInfo, user);
        UserInfoDTO dto = this.activeAndLogin(loginInfo, user, basicParam, equipment);
        if (!deviceExistMessage.isSuccess()) {
            this.saveNewUserCache(userAuth.getUserId());
        }
        LoginMeta meta = new LoginMeta(dto, !deviceExistMessage.isSuccess());
        this.userLoginHistoryService.save(equipment, basicParam, user.getId(), loginInfo.getRegIp());
        return meta;
    }

    private String generateToken(Long userId, String token) {
        if (null == token) {
            token = JwtTokenUtil.generateToken((Long)userId);
        }
        this.redisHashMapAdapter.put(UserRedisKey.HASH_USER_TOKEN, String.valueOf(userId), (Object)token);
        return token;
    }

    private UserInfoDTO activeAndLogin(LoginInfo loginInfo, User user, BasicParam basicParam, String equipment) {
        this.logger.debug("\u767b\u5f55->\u5f00\u59cb\u66f4\u65b0\u7528\u6237\u6570\u636e\uff0c\u53c2\u6570\uff1auser:[{}],\u8bbe\u5907\u53f7\uff1a[{}]", JSONObject.toJSON((Object)user), (Object)equipment);
        user.setToken(this.generateToken(user.getId(), null));
        user.setRefreshtoken(JwtTokenUtil.generateToken((Long)user.getId()));
        user.setEquipment(equipment);
        user.setLastLoginIp(loginInfo.getLastLoginIp());
        user.setLastLoginTime(new Date());
        user.setChannelId(user.getChannelId() == 0L ? this.channelService.getChannelByCode(basicParam.getChnl()).getId() : user.getChannelId());
        user.setInfoCompleteState(((UserPersonalInfoService)SpringContextHolder.getBean(UserPersonalInfoService.class)).initUserInfoCompleteStatus(user));
        this.logger.debug("\u7528\u6237[{}]\u5bf9\u5e94\u7684\u72b6\u6001\uff1a[{}]", (Object)user.getId(), (Object)user.getState());
        this.updateUserActive(user, basicParam, equipment);
        this.userMapper.updateByPrimaryKeySelective(user);
        UserInfoDTO userInfoDetail = this.userService.loadUserToRedis(user.getId());
        this.addAuthInfo(userInfoDetail);
        return userInfoDetail;
    }

    private void updateUserActive(User user, BasicParam basicParam, String equipment) {
        if (2 == user.getState()) {
            UserAccount userAccount = this.userAccountService.getUserAccountDetail(user.getId());
            user.setState(Byte.valueOf((byte)1));
            boolean isExistEquipment = true;
            if (null != equipment) {
                isExistEquipment = this.userEquipmentMapper.countEquipment(equipment, "DRAW") > 0;
            }
            BigDecimal cash = this.cashFlowService.getMySelfBounty(userAccount.getUserId());
            Long relationId = this.updateInviteStatus(user, !isExistEquipment, basicParam);
            this.updateUserCashState(userAccount, relationId, !isExistEquipment, cash);
            if (!isExistEquipment && cash.compareTo(BigDecimal.ZERO) > 0) {
                UserEquipment userEquipment = new UserEquipment(Long.valueOf(this.nextId()), equipment, "DRAW");
                this.userEquipmentService.addUserEquipment(userEquipment);
            }
            this.scheduleService.remove(InviteRelationshipTask.generateTaskName(user.getInviteUserId(), user.getId()));
            this.bizLogIntegrationService.createUser(user, basicParam, userAccount);
        }
    }

    private void addAuthInfo(UserInfoDTO userInfo) {
        userInfo.setCombineAuthCode(this.userAuthCodeService.getAuthCombineCode(userInfo.getId()));
        userInfo.setAuthResources(this.userAuthCodeService.getAuthResources(userInfo.getId()));
    }

    private Long updateInviteStatus(User user, boolean isEffective, BasicParam basicParam) {
        if (null == user.getInviteUserId()) {
            return null;
        }
        InviteRecord inviteRecord = this.inviteRecordService.getInviteRecordByInvitedUser(user.getInviteUserId(), user.getId());
        if (null == inviteRecord) {
            return null;
        }
        if (InviteTypeEnum.CHATROOM.name().equals(inviteRecord.getType())) {
            Long inviteUserId = inviteRecord.getUserId();
            this.logger.info("\u89e3\u9501\u7528\u6237\u62a2\u7ea2\u5305\u7684\u6743\u9650,userId:[{}]", (Object)inviteUserId);
            ClientVersionDto clientVersionDto = this.userEquipmentMapper.queryClientVersion(inviteUserId);
            if (null != clientVersionDto && StringUtils.compareVersion((String)clientVersionDto.getVersion(), (String)"3.0.0") >= 0 && !this.userAuthCodeService.hasAuth(inviteUserId, AuthCodeEnum.PICK_RED_PACKAGE).booleanValue()) {
                LocationUserInfoDTO location = this.userService.getLocationUserInfo(inviteUserId);
                this.userAuthCodeService.addAuthCode(inviteUserId, AuthCodeEnum.PICK_RED_PACKAGE);
                ImChatroom chatroom = this.imIntegrationService.getChatRoom(location.getLocationCode());
                if (chatroom.getEnableTimingRedPacket() == 1) {
                    this.pushMsgIntegrationService.pushUnlockPickAuth(inviteUserId, user.getNickname(), location);
                }
                PointReportParam reportParam = PointReportParam.build((BasicParam)basicParam);
                reportParam.e("3034");
                reportParam.ev(StringUtils.join((Object[])new String[]{"109.", String.valueOf(inviteUserId)}));
                reportParam.put("uid", String.valueOf(user.getId()));
                this.bizLogIntegrationService.point(reportParam);
            }
            PointReportParam reportParam = PointReportParam.build((BasicParam)basicParam);
            reportParam.e("3034");
            reportParam.ev(StringUtils.join((Object[])new String[]{"110.", String.valueOf(inviteUserId)}));
            reportParam.put("uid", String.valueOf(user.getId()));
            this.bizLogIntegrationService.point(reportParam);
        }
        if (AwardTypeEnum.CASH.name().equals(inviteRecord.getAwardType())) {
            this.changeInviteAwardState(inviteRecord, isEffective);
        }
        if (isEffective) {
            this.bizLogIntegrationService.inviteSuccessed(inviteRecord.getUserId(), user.getId(), null == user.getRegisterClient() ? null : Integer.valueOf(user.getRegisterClient()));
        }
        return inviteRecord.getId();
    }

    private void updateUserCashState(UserAccount userAccount, Long relationId, boolean isEffective, BigDecimal cash) {
        this.logger.debug("\u65b0\u7528\u6237[{}]\u9996\u6b21\u767b\u9646\u4e34\u65f6\u8d4f\u91d1[{}]\u8f6c\u6362\u4e3a\u53ef\u63d0\u73b0\u8d4f\u91d1", (Object)userAccount.getUserId(), (Object)cash);
        if (cash.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        if (isEffective) {
            AccountCashParam param = new AccountCashParam(userAccount.getUserId(), CashEnum.TEMP_CASH.name(), Boolean.valueOf(false), cash, relationId, null, CashFlowConvertTypeEnum.TEMP_TO_DRAWABLE.name());
            this.userAccountService.transferCash(param);
        } else {
            AccountCashParam accountCashParam = new AccountCashParam();
            accountCashParam.setUserId(userAccount.getUserId());
            accountCashParam.setCashType(CashEnum.TEMP_CASH.name());
            accountCashParam.setAddTotal(Boolean.valueOf(false));
            accountCashParam.setCashFlowType(CashFlowTypeEnum.INVALID_PACKET.name());
            accountCashParam.setCash(cash.negate());
            accountCashParam.setRelationId(relationId);
            this.userAccountService.addCash(accountCashParam);
        }
    }

    private void changeInviteAwardState(InviteRecord inviteRecord, boolean isEffective) {
        if (inviteRecord == null) {
            return;
        }
        if (!InviteRecordStateEnum.ACCEPT_INVITE.name().equals(inviteRecord.getInviteState())) {
            this.logger.info("\u5f53\u524d\u9080\u8bf7\u4eba[{}]\u4e0e\u53d7\u9080\u4eba[{}]\u7684\u72b6\u6001\u5904\u4e8e[{}]------\u4e0d\u4e88\u5904\u7406", new Object[]{inviteRecord.getUserId(), inviteRecord.getInvitedUserId(), inviteRecord.getInviteState()});
        }
        if (isEffective) {
            AccountCashParam param = new AccountCashParam(inviteRecord.getUserId(), CashEnum.STABILIZE_CASH.name(), Boolean.valueOf(false), inviteRecord.getAward(), inviteRecord.getId(), CashFlowTypeEnum.PROMOTE_BOUNTY.name(), CashFlowConvertTypeEnum.TEMP_TO_STABILIZE.name());
            this.userAccountService.transferCash(param);
            inviteRecord.setInviteState(InviteRecordStateEnum.LOGIN_APP.getName());
            inviteRecord.setEffectTime(null);
            inviteRecord.setAwardType(AwardTypeEnum.CASH.name());
        } else {
            AccountCashParam accountCashParam = new AccountCashParam();
            accountCashParam.setUserId(inviteRecord.getUserId());
            accountCashParam.setCashType(CashEnum.TEMP_CASH.name());
            accountCashParam.setAddTotal(Boolean.valueOf(false));
            accountCashParam.setCashFlowType(CashFlowTypeEnum.INVALID_BOUNTY.name());
            accountCashParam.setCash(inviteRecord.getAward().negate());
            accountCashParam.setRelationId(inviteRecord.getId());
            this.userAccountService.addCash(accountCashParam);
            inviteRecord.setInviteState(InviteRecordStateEnum.OVERDUE_INVALID.name());
            inviteRecord.setAwardType(AwardTypeEnum.CASH.name());
            inviteRecord.setStatus(Byte.valueOf((byte)0));
        }
        this.inviteRecordService.updateInviteRecord(inviteRecord);
    }

    private void addWechatLoginInfo(LoginInfo loginInfo, User user) {
        this.logger.debug("\u7528\u6237\u767b\u9646\u4f20\u5165\u7684\u53c2\u6570\uff1a[{}]", (Object)JSON.toJSONString((Object)loginInfo));
        if (3 == loginInfo.getType()) {
            loginInfo.setUnionId(loginInfo.getLoginName());
        }
        if (null != loginInfo.getOpenId() && null != loginInfo.getUnionId()) {
            boolean isBindMsg;
            List userAuthList = this.userAuthMapper.listByUserId(user.getId());
            if (!CollectionUtils.isEmpty((Collection)userAuthList)) {
                this.logger.debug("\u5f53\u524d\u7528\u6237\u521b\u5efaunionId\u9274\u6743\u4fe1\u606f:\u7528\u6237id\uff1a[{}], unionId:[{}]", (Object)user.getId(), (Object)loginInfo.getUnionId());
                isBindMsg = userAuthList.stream().anyMatch(e -> e.getIdentifier().equals(loginInfo.getUnionId()));
                if (!isBindMsg) {
                    user.setWeixin(loginInfo.getUnionId());
                    this.userAuthService.addUserAuth((byte)3, user.getId(), loginInfo.getUnionId(), null);
                }
            }
            if (!(isBindMsg = userAuthList.stream().anyMatch(e -> e.getIdentifier().equals(loginInfo.getOpenId())))) {
                this.logger.debug("\u5f53\u524d\u7528\u6237\u521b\u5efaAPP\u5fae\u4fe1\u6388\u6743\u767b\u9646openId\u9274\u6743\u4fe1\u606f:\u7528\u6237id\uff1a[{}], openId:[{}]", (Object)user.getId(), (Object)loginInfo.getOpenId());
                this.userAuthService.addUserAuth((byte)6, user.getId(), loginInfo.getOpenId(), null);
            }
        }
    }

    private void copyUserInfo(LoginInfo loginInfo, User user) {
        if (loginInfo.getId() == null || loginInfo.getId() == 0L) {
            this.logger.warn(LogMarker.BIZ, "\u7528\u6237\u6ce8\u518c\uff0c\u4f46\u662f\u6ca1\u6709\u63d0\u4f9b\u9759\u9ed8\u6ce8\u518cID[H5\u7ad9\u5916\u6ce8\u518c\u4f8b\u5916]\uff0cloginInfo:[{}],user:[{}]", (Object)loginInfo, (Object)user);
            this.userNewsIntegrationService.initUserNewsImage(user.getId(), null);
        } else {
            this.logger.debug(LogMarker.BIZ, "\u7528\u6237\u6ce8\u518c,\u4ece\u8bbf\u5ba2\u8d26\u53f7\u62f7\u8d1d\u6807\u7b7e\u6743\u91cd\u4fe1\u606f\u548c\u9891\u9053\u5217\u8868\uff0cloginInfo:[{}],user:[{}]", (Object)loginInfo, (Object)user);
            this.userNewsIntegrationService.initUserNewsImage(user.getId(), loginInfo.getId());
        }
    }

    @Override
    @Retryable(value={RetryException.class}, backoff=@Backoff(value=300L))
    public Json<LoginMeta> registerAndBindingPhone(LoginInfo loginInfo, Long userId, BasicParam basicParam) {
        LoginMeta meta;
        if (!this.userParamCheckService.bindingAndRegisterCheckParam(loginInfo)) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u53c2\u6570\u9519\u8bef");
        }
        Message messageByCheckAuth = this.userAuthService.checkBindExist(loginInfo.getType(), loginInfo.getLoginName());
        if (!messageByCheckAuth.isSuccess()) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)messageByCheckAuth.getLastMessage());
        }
        User user = this.getUserByType(loginInfo);
        Message messageByCheckUser = this.userParamCheckService.checkRepeatBind(user, loginInfo);
        if (!messageByCheckUser.isSuccess()) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)messageByCheckUser.getLastMessage());
        }
        if (null != userId && null != (user = this.userMapper.selectByPrimaryKey(userId)) && 0 == user.getState()) {
            user = null;
        }
        if (1 == loginInfo.getType() && StringUtils.isNotBlank((CharSequence)loginInfo.getCode()) && !this.smsIntegrationService.verifySmsCodeByType(Byte.valueOf((byte)2), loginInfo.getPhone(), loginInfo.getCode()).booleanValue()) {
            return ResultUtil.genFailedResult((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u9a8c\u8bc1\u7801");
        }
        try {
            meta = this.createAndBinding(user, loginInfo, basicParam);
        }
        catch (UserRepeatCreateException e) {
            this.logger.warn("\u91cd\u590d\u521b\u5efa\u7528\u6237\uff0c\u8fdb\u884c\u91cd\u8bd5\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)loginInfo);
            throw new RetryException("\u7528\u6237\u5df2\u5b58\u5728\uff0c\u91cd\u65b0\u521b\u5efa");
        }
        return ResultUtil.genSuccessResult((Object)meta);
    }

    private User getUserByType(LoginInfo loginInfo) {
        User user = null;
        if (3 == loginInfo.getType()) {
            user = this.userMapper.findByWeixin(loginInfo.getLoginName());
        } else if (1 == loginInfo.getType()) {
            user = this.userMapper.findByPhone(loginInfo.getPhone());
        }
        return user;
    }

    private LoginMeta createAndBinding(User user, LoginInfo loginInfo, BasicParam basicParam) throws UserRepeatCreateException {
        LoginMeta meta = new LoginMeta();
        if (null == user) {
            user = this.addDefaultUser(loginInfo, basicParam);
            this.generateToken(user.getId(), user.getToken());
        } else {
            this.syncThirdPartyInfo(user, loginInfo);
            this.changeToken(user, loginInfo, basicParam);
            this.addUserAuth(loginInfo, user.getId());
        }
        UserInfoDTO dto = this.userService.convertUserToDTO(user);
        boolean isFirstLogin = false;
        EquipmentDTO equipmentDTO = this.bizIntegrationService.getDevice(basicParam.getDevcId());
        String equipment = equipmentDTO == null ? null : equipmentDTO.getId();
        Message deviceExistMessage = this.userLoginHistoryService.isDeviceExistByDeviceId(user.getId(), equipment);
        if (!deviceExistMessage.isSuccess()) {
            isFirstLogin = true;
        }
        if (isFirstLogin) {
            this.saveNewUserCache(user.getId());
        }
        this.addAuthInfo(dto);
        meta.setUser(dto);
        meta.setFirstLogin(isFirstLogin);
        this.userLoginHistoryService.save(equipment, basicParam, user.getId(), loginInfo.getRegIp());
        this.userService.putUserToRedis(user);
        return meta;
    }

    private void saveNewUserCache(Long id) {
        KeyGenerator key = RedisConfig.NEW_USER_LOGIN.copy().appendKey((Object)id);
        this.redisStringAdapter.set(key, (Object)true);
        this.redisStringAdapter.expire(key, (long)DateUtils.getCurSeconds());
    }

    private void changeToken(User user, LoginInfo loginInfo, BasicParam basicParam) {
        user.setToken(this.generateToken(user.getId(), null));
        if (loginInfo.getSex() != null) {
            user.setSex(loginInfo.getSex());
        }
        user.setLastLoginTime(new Date());
        this.userMapper.updateByPrimaryKeySelective(user);
    }

    private User addDefaultUser(LoginInfo loginInfo, BasicParam basicParam) throws UserRepeatCreateException {
        return this.userRegistrationService.addUser(loginInfo, basicParam, (byte)1);
    }

    private void firstLogin(Long userId, String wechat, Integer platform) {
    }

    private void addUserAuth(LoginInfo loginInfo, Long userId) {
        this.logger.info("\u6dfb\u52a0\u7528\u6237\u6743\u9650\u8ba4\u8bc1");
        UserAuth auth = new UserAuth();
        auth.setUserId(userId);
        auth.setType(loginInfo.getType());
        if (StringUtils.equals((CharSequence)loginInfo.getPhone(), (CharSequence)loginInfo.getLoginName())) {
            auth.setIdentifier(loginInfo.getPhone());
            if (StringUtils.isNotEmpty((CharSequence)loginInfo.getPassword())) {
                auth.setCredential(MD5Util.hgmd5((String)loginInfo.getPassword()));
            }
            this.userAuthMapper.insertSelective(auth);
        }
        if (StringUtils.notEquals((CharSequence)loginInfo.getPhone(), (CharSequence)loginInfo.getLoginName())) {
            auth.setIdentifier(loginInfo.getLoginName());
            this.userAuthMapper.insertSelective(auth);
        }
    }

    private void syncThirdPartyInfo(User user, LoginInfo loginInfo) {
        if (1 == loginInfo.getType()) {
            user.setPhone(loginInfo.getLoginName());
        } else if (2 == loginInfo.getType()) {
            user.setQq(loginInfo.getLoginName());
        } else if (4 == loginInfo.getType()) {
            user.setWeibo(loginInfo.getLoginName());
        } else if (3 == loginInfo.getType()) {
            user.setWeixin(loginInfo.getLoginName());
            if (null != loginInfo.getNickname()) {
                user.setNickname(user.getNickname() == null ? loginInfo.getNickname() : user.getNickname());
            }
            if (null != loginInfo.getHeadImg()) {
                user.setHeadImg(user.getHeadImg() == null ? loginInfo.getHeadImg() : user.getHeadImg());
            }
        }
    }

    @Autowired
    public LoginServiceImpl(SmsIntegrationService smsIntegrationService, UserAuthMapper userAuthMapper, UserMapper userMapper, UserService userService, RedisHashMapAdapter redisHashMapAdapter, RedisStringAdapter redisStringAdapter, AppVersionIntegrationService appVersionIntegrationService, UserAuthService userAuthService, BizLogIntegrationService bizLogIntegrationService, UserLoginHistoryService userLoginHistoryService, UserNewsIntegrationService userNewsIntegrationService, UserSyncService userSyncService, InviteRecordService inviteRecordService, UserAccountService userAccountService, CashFlowService cashFlowService, UserEquipmentService userEquipmentService, ChannelService channelService, BizIntegrationService bizIntegrationService, UserParamCheckService userParamCheckService, UserEquipmentMapper userEquipmentMapper, UserRegistrationService userRegistrationService, UserAuthCodeService userAuthCodeService, ScheduleService scheduleService, PushMsgIntegrationService pushMsgIntegrationService, IMIntegrationService imIntegrationService) {
        this.smsIntegrationService = smsIntegrationService;
        this.userAuthMapper = userAuthMapper;
        this.userMapper = userMapper;
        this.userService = userService;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.redisStringAdapter = redisStringAdapter;
        this.appVersionIntegrationService = appVersionIntegrationService;
        this.userAuthService = userAuthService;
        this.bizLogIntegrationService = bizLogIntegrationService;
        this.userLoginHistoryService = userLoginHistoryService;
        this.userNewsIntegrationService = userNewsIntegrationService;
        this.userSyncService = userSyncService;
        this.inviteRecordService = inviteRecordService;
        this.userAccountService = userAccountService;
        this.cashFlowService = cashFlowService;
        this.userEquipmentService = userEquipmentService;
        this.channelService = channelService;
        this.bizIntegrationService = bizIntegrationService;
        this.userParamCheckService = userParamCheckService;
        this.userEquipmentMapper = userEquipmentMapper;
        this.userRegistrationService = userRegistrationService;
        this.userAuthCodeService = userAuthCodeService;
        this.scheduleService = scheduleService;
        this.pushMsgIntegrationService = pushMsgIntegrationService;
        this.imIntegrationService = imIntegrationService;
    }

    private class DefaultUserWarper {
        User user;
        UserInfoDTO dto;

        DefaultUserWarper(User user, UserInfoDTO dto) {
            this.user = user;
            this.dto = dto;
        }
    }
}

