/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.login.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.constant.InfoCombineStateEnum;
import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.account.UserAccountService;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.domain.UserAuthMapper;
import com.bxm.localnews.user.domain.UserMapper;
import com.bxm.localnews.user.dto.BaseUserInfo;
import com.bxm.localnews.user.dto.EquipmentDTO;
import com.bxm.localnews.user.dto.LocationDTO;
import com.bxm.localnews.user.dto.LocationUserInfoDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.dto.UserTbkInfo;
import com.bxm.localnews.user.dto.WxUserInfo;
import com.bxm.localnews.user.enums.GoldEnum;
import com.bxm.localnews.user.enums.GoldFlowTypeEnum;
import com.bxm.localnews.user.enums.LevelEnum;
import com.bxm.localnews.user.enums.TaskEnum;
import com.bxm.localnews.user.integration.BizIntegrationService;
import com.bxm.localnews.user.integration.LocationIntegrationService;
import com.bxm.localnews.user.integration.MissionIntegrationService;
import com.bxm.localnews.user.integration.PushMsgIntegrationService;
import com.bxm.localnews.user.integration.VipIntegrationService;
import com.bxm.localnews.user.invite.InviteRecordService;
import com.bxm.localnews.user.login.UserAuthService;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.param.AccountGoldParam;
import com.bxm.localnews.user.param.RecordWechatParam;
import com.bxm.localnews.user.param.RiskParam;
import com.bxm.localnews.user.param.TempUserParam;
import com.bxm.localnews.user.properties.HomePageConfigProperties;
import com.bxm.localnews.user.properties.UserProperties;
import com.bxm.localnews.user.support.ExtendedService;
import com.bxm.localnews.user.support.impl.RiskRecordServiceImpl;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserAuth;
import com.bxm.newidea.component.emoji.EmojiCodeParser;
import com.bxm.newidea.component.jwt.tools.JwtTokenUtil;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="userService")
@RefreshScope
public class UserServiceImpl
extends BaseService
implements UserService {
    @Resource
    private UserAuthService userAuthService;
    @Resource
    private UserAccountService userAccountService;
    @Resource
    private UserMapper userMapper;
    @Resource
    private UserAuthMapper userAuthMapper;
    @Resource
    private UserProperties userProperties;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private LocationIntegrationService locationIntegrationService;
    @Resource
    private MissionIntegrationService missionIntegrationService;
    @Resource
    private InviteRecordService inviteRecordService;
    @Resource
    private DistributedLock distributedLock;
    @Resource
    private VipIntegrationService vipIntegrationService;
    @Resource
    private PushMsgIntegrationService pushMsgIntegrationService;
    @Resource
    private HomePageConfigProperties homePageConfigProperties;
    @Resource
    private ExtendedService extendedService;
    @Resource
    private RiskRecordServiceImpl riskRecordService;
    @Resource
    private BizIntegrationService bizIntegrationService;

    @Override
    public UserInfoDTO getUserFromRedisDB(Long userId) {
        String userStr = (String)this.redisHashMapAdapter.get(RedisConfig.USER_INFO, String.valueOf(userId), String.class);
        UserInfoDTO dto = (UserInfoDTO)JSON.parseObject((String)userStr, UserInfoDTO.class);
        if (null == dto) {
            dto = this.loadUserToRedis(userId);
            this.logger.info("\u7528\u6237[{}]\u4e3anull\uff0c\u91cd\u65b0\u52a0\u8f7d\u7528\u6237\u5728\u6570\u636e\u5e93\u7684\u6570\u636e:[{}]", (Object)userId, JSONObject.toJSON((Object)dto));
        } else if (StringUtils.isEmpty((CharSequence)dto.getNickname()) || StringUtils.isEmpty((CharSequence)dto.getHeadImg())) {
            dto = this.loadUserToRedis(userId);
            this.logger.info("\u7528\u6237[{}]\u4eceredis\u83b7\u53d6\u5230\u7684\u5934\u50cf\u6216\u8005\u6635\u79f0\u4e3a\u7a7a\uff0c\u91cd\u65b0\u52a0\u8f7d\u7528\u6237\u5728\u6570\u636e\u5e93\u7684\u6570\u636e:[{}]", (Object)userId, JSONObject.toJSON((Object)dto));
        }
        this.logger.debug("\u83b7\u53d6\u7528\u6237[{}]\u8be6\u7ec6\u4fe1\u606f[{}]", (Object)userId, (Object)JSON.toJSONString((Object)dto));
        return dto;
    }

    @Override
    public UserInfoDTO loadUserToRedis(Long userId) {
        User user = this.userMapper.selectByPrimaryKey(userId);
        if (null == user) {
            this.redisHashMapAdapter.put(RedisConfig.USER_INFO, String.valueOf(userId), (Object)"");
            return null;
        }
        return this.putUserToRedis(user);
    }

    @Override
    public UserInfoDTO putUserToRedis(User user) {
        LocationDTO locationByGeocode;
        this.logger.debug("\u66f4\u65b0\u7528\u6237\u7f13\u5b58\uff1a[{}]", JSONObject.toJSON((Object)user));
        UserInfoDTO dto = this.convertUserToDTO(user);
        dto.setIndustry(this.getIndustryInfo(user));
        if (StringUtils.isNotEmpty((CharSequence)user.getPersonalProfile())) {
            dto.setIsDefaultPersonalProfile(Boolean.FALSE);
        } else {
            dto.setIsDefaultPersonalProfile(Boolean.TRUE);
            dto.setPersonalProfile(this.homePageConfigProperties.getDefaultPersonalProfile());
        }
        if (null != user.getHometownCode() && null != (locationByGeocode = this.locationIntegrationService.getLocationByGeocode(user.getHometownCode()))) {
            dto.setHometownName(locationByGeocode.getFullName());
        }
        if (null != user.getLocationCode() && null != (locationByGeocode = this.locationIntegrationService.getLocationByGeocode(user.getLocationCode()))) {
            dto.setLocationName(locationByGeocode.getFullName());
        }
        this.redisHashMapAdapter.put(RedisConfig.USER_INFO, String.valueOf(user.getId()), (Object)JSON.toJSONString((Object)dto));
        return dto;
    }

    private String getIndustryInfo(User user) {
        StringBuilder industryBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)user.getJobTitle()) && StringUtils.isNotBlank((CharSequence)user.getCompany())) {
            industryBuilder.append(user.getCompany()).append(user.getJobTitle());
        }
        if (StringUtils.isBlank((CharSequence)user.getJobTitle()) && StringUtils.isBlank((CharSequence)user.getCompany()) && StringUtils.isNotBlank((CharSequence)user.getJobCategoryName())) {
            industryBuilder.append(user.getJobCategoryName());
        }
        if (StringUtils.isNotBlank((CharSequence)user.getJobTitle()) && StringUtils.isBlank((CharSequence)user.getCompany()) && StringUtils.isNotBlank((CharSequence)user.getJobCategoryName())) {
            industryBuilder.append(user.getJobTitle());
        }
        if (StringUtils.isBlank((CharSequence)user.getJobTitle()) && StringUtils.isNotBlank((CharSequence)user.getCompany())) {
            industryBuilder.append(user.getCompany());
        }
        if (industryBuilder.length() > 0) {
            return industryBuilder.toString();
        }
        return null;
    }

    @Override
    public boolean checkUserExistByPhone(String phone, Integer flag) {
        User user = this.userMapper.findByPhone(phone);
        if (null == user) {
            return false;
        }
        UserAuth userAuth = this.userAuthMapper.selectByUserId(Byte.valueOf((byte)3), user.getId());
        if (flag == 1) {
            return userAuth != null;
        }
        return true;
    }

    @Override
    public UserInfoDTO convertUserToDTO(User user) {
        UserInfoDTO dto = new UserInfoDTO();
        BeanUtils.copyProperties((Object)user, (Object)dto);
        if (StringUtils.isBlank((CharSequence)dto.getNickname())) {
            dto.setNickname(StringUtils.hideMobile((String)user.getPhone()));
        }
        if (StringUtils.isBlank((CharSequence)dto.getHeadImg())) {
            dto.setHeadImg(this.userProperties.getDefaultHeadImgUrl());
        }
        dto.setIsTempNickName(Byte.valueOf((byte)1));
        return dto;
    }

    @Override
    public Json<UserInfoDTO> refreshToken(Long userId, String refreshToken) {
        User user = this.userMapper.getUserByRefreshToken(userId.longValue(), refreshToken);
        if (null == user) {
            return ResultUtil.genFailedResult((int)RespCode.UNAUTHORIZED, (String)"\u767b\u5f55\u5931\u6548");
        }
        user.setExpiretime(Long.valueOf(JwtTokenUtil.generateExpirationDate().getTime()));
        user.setToken(JwtTokenUtil.generateToken((Long)userId));
        this.userMapper.updateByPrimaryKeySelective(user);
        UserInfoDTO dto = this.convertUserToDTO(user);
        return ResultUtil.genSuccessResult((Object)dto);
    }

    @Override
    public void checkCompleteInfo(User user) {
        long infoCompleteStatus = user.getInfoCompleteState();
        this.logger.debug("\u7528\u6237\u5b8c\u5584\u8d44\u6599\u7a0b\u5ea6\u4fe1\u606f:[{}]", (Object)infoCompleteStatus);
        if (InfoCombineStateEnum.values().length == InfoCombineStateEnum.getInfoCompleteStatus((Long)infoCompleteStatus)) {
            this.logger.debug("\u7528\u6237\u5df2\u5b8c\u5584\u8d44\u6599\uff0c\u8c03\u7528\u5b8c\u6210\u8d44\u6599\u63a5\u53e3:[{}]", (Object)infoCompleteStatus);
            this.missionIntegrationService.completeTask(user.getId(), TaskEnum.TASK_IMPROVE_INFO, null);
        }
    }

    @Override
    public Message getWxUserInfo(TempUserParam tempUserParam, HttpServletRequest request) {
        Message message = this.createTempUser(tempUserParam);
        if (message.isSuccess()) {
            WxUserInfo wxUserInfo = new WxUserInfo();
            wxUserInfo.setUserId(Long.valueOf((Long)message.getParamMap().get("userId")));
            wxUserInfo.setHeadImg(tempUserParam.getHeadImg());
            wxUserInfo.setUnionId(tempUserParam.getUnionId());
            wxUserInfo.setNickname(tempUserParam.getNickName());
            this.logger.debug("\u521b\u5efa\u4e34\u65f6\u7528\u6237\u6210\u529f:[{}]", JSONObject.toJSON((Object)wxUserInfo));
            return Message.build((boolean)true).addParam("wxUserInfo", (Object)wxUserInfo);
        }
        return message;
    }

    @Override
    public LocationUserInfoDTO getLocationUserInfo(Long userId) {
        return this.userMapper.getLocationUserInfo(userId);
    }

    @Override
    public User selectByPrimaryKey(Long userId) {
        return this.userMapper.selectByPrimaryKey(userId);
    }

    @Override
    public Boolean checkUnionIdIsUser(String unionId) {
        UserAuth userAuth = this.userAuthMapper.selectByUserAuth(Byte.valueOf((byte)3), unionId);
        if (userAuth == null) {
            return false;
        }
        User user = this.userMapper.selectByPrimaryKey(userAuth.getUserId());
        return user == null || user.getState() != 2;
    }

    @Override
    public Boolean isRiskUser(Long userId) {
        User user = this.userMapper.selectByPrimaryKey(userId);
        return user.getRisk() == 1;
    }

    @Override
    public Long addWSTAppletUser() {
        User user = this.saveWSTUser();
        return user.getId();
    }

    private User saveWSTUser() {
        User user = new User();
        user.setRegisterClient("5");
        user.setAge(0);
        user.setSex(Byte.valueOf((byte)0));
        user.setState(Byte.valueOf((byte)2));
        user.setLevel(LevelEnum.INITIAL_USER.getType());
        user.setIsNew(Byte.valueOf((byte)0));
        user.setIsTempNickName(Byte.valueOf((byte)1));
        user.setIsTempHeadImg(Byte.valueOf((byte)1));
        user.setNewbieGuideFlag(Byte.valueOf((byte)0));
        int count = this.userMapper.insertSelective(user);
        if (count > 0) {
            User updateUser = new User();
            updateUser.setToken(JwtTokenUtil.generateToken((Long)user.getId()));
            updateUser.setRefreshtoken(JwtTokenUtil.generateToken((Long)user.getId()));
            updateUser.setExpiretime(Long.valueOf(JwtTokenUtil.generateExpirationDate().getTime()));
            this.userMapper.updateByPrimaryKeySelective(updateUser);
            this.loadUserToRedis(user.getId());
        }
        return user;
    }

    @Override
    public Boolean isTempUser(Long userId) {
        User user = this.userMapper.selectByPrimaryKey(userId);
        return 2 == user.getState();
    }

    @Override
    public Boolean isNormalUser(Long userId) {
        User user = this.userMapper.selectByPrimaryKey(userId);
        return null != user && 1 == user.getState();
    }

    @Override
    public Message createTempUser(TempUserParam userParam) {
        if (StringUtils.isBlank((CharSequence)userParam.getUnionId()) && null == userParam.getUserId()) {
            this.logger.error("\u521b\u5efa\u4e34\u65f6\u7528\u6237\u51fa\u73b0\u9519\u8bef\uff0c\u53c2\u6570\u975e\u6cd5:[{}]", JSONObject.toJSON((Object)userParam));
            return Message.build((boolean)false, (String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        this.logger.debug("\u5f00\u59cb\u521b\u5efa\u4e34\u65f6\u7528\u6237\uff0c\u53c2\u6570:[{}]", (Object)JSON.toJSONString((Object)userParam));
        User user = new User();
        this.convertTempUser(userParam, user);
        UserAuth unionUserAuth = null;
        if (StringUtils.isNotBlank((CharSequence)userParam.getUnionId())) {
            unionUserAuth = this.userAuthMapper.selectByUserAuth(Byte.valueOf((byte)3), userParam.getUnionId());
        }
        User existedUser = null;
        Long userId = null;
        if (null != userParam.getUserId()) {
            existedUser = this.userMapper.selectByPrimaryKey(userParam.getUserId());
        } else if (StringUtils.isNotBlank((CharSequence)userParam.getUnionId()) && null != unionUserAuth) {
            existedUser = this.userMapper.selectByPrimaryKey(unionUserAuth.getUserId());
        }
        if (null != existedUser) {
            userId = existedUser.getId();
        }
        boolean isInsertInviteRecord = false;
        if (null != existedUser && 2 == existedUser.getState()) {
            this.logger.debug("\u6839\u636e\u7528\u6237id\u6216\u8005unionId\u80fd\u627e\u5230\u5df2\u5b58\u5728\u7684\u7528\u6237\uff0c\u66f4\u65b0\u9080\u8bf7\u5173\u7cfb");
            isInsertInviteRecord = this.updateUserInvitation(user, existedUser);
        } else if (null == existedUser && StringUtils.isNotBlank((CharSequence)userParam.getUnionId())) {
            this.logger.debug("\u6839\u636e\u7528\u6237id\u6216\u8005unionId\u65e0\u6cd5\u67e5\u8be2\u5230\u7528\u6237\uff0c\u521b\u5efa\u65b0\u7528\u6237");
            if (this.distributedLock.lock(userParam.getUnionId(), userParam.getUnionId(), 1L, TimeUnit.SECONDS)) {
                this.userMapper.insertSelective(user);
                userId = user.getId();
                this.userAuthService.addUserAuth((byte)3, userId, userParam.getUnionId(), null);
                this.userAccountService.createUserAccount(userId);
                isInsertInviteRecord = true;
            }
        }
        this.loadUserToRedis(userId);
        this.afterProcessing(userParam, userId);
        this.addInviteRecord(userParam, userId, isInsertInviteRecord);
        return Message.build((boolean)true).addParam("userId", (Object)userId);
    }

    private void afterProcessing(TempUserParam userParam, Long userId) {
        if (null != userParam.getOpenId()) {
            if (InviteTypeEnum.APPLETDRAW.getName().equals(userParam.getInviteType())) {
                UserAuth appletUserAuth = this.userAuthMapper.selectByUserAuth(Byte.valueOf((byte)7), userParam.getOpenId());
                if (null == appletUserAuth || null == appletUserAuth.getUserId()) {
                    this.userAuthService.addUserAuth((byte)7, userId, userParam.getOpenId(), null);
                }
            } else {
                UserAuth weixinUserAuth = this.userAuthMapper.selectByUserAuth(Byte.valueOf((byte)5), userParam.getOpenId());
                if (null == weixinUserAuth || null == weixinUserAuth.getUserId()) {
                    this.userAuthService.addUserAuth((byte)5, userId, userParam.getOpenId(), null);
                }
            }
        }
    }

    @Override
    public Message updateTempUser(TempUserParam userParam) {
        Message message = Message.build();
        if (StringUtils.isBlank((CharSequence)userParam.getUnionId())) {
            return message;
        }
        UserAuth openUserAuth = this.userAuthMapper.selectByUserAuth(Byte.valueOf((byte)8), userParam.getOpenId());
        if (null == openUserAuth) {
            this.logger.warn("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u8fdb\u884c\u9759\u9ed8\u767b\u9646\uff0c\u7981\u6b62\u521b\u5efa\u7528\u6237");
            return message;
        }
        this.logger.debug("\u5f00\u59cb\u66f4\u65b0\u3010\u4e07\u4e8b\u901a\u5c0f\u7a0b\u5e8f\u3011\u4e34\u65f6\u7528\u6237\uff1a{}", (Object)JSON.toJSONString((Object)userParam));
        User user = this.userMapper.selectByUserId(openUserAuth.getUserId().longValue());
        Long userId = null;
        boolean isInsertInviteRecord = false;
        UserAuth unionUserAuth = this.userAuthMapper.selectByUserAuth(Byte.valueOf((byte)3), userParam.getUnionId());
        if (null == unionUserAuth || null == unionUserAuth.getUserId()) {
            this.logger.info("\u5f53\u524d\u7528\u6237\u672a\u8fdb\u5165APP--------\u76f4\u63a5\u7ed1\u5b9a\u7528\u6237, unionId: " + userParam.getUnionId());
            if (this.distributedLock.lock(userParam.getUnionId(), userParam.getUnionId(), 1L, TimeUnit.SECONDS)) {
                this.convertTempUser(userParam, user);
                user.setState(Byte.valueOf((byte)1));
                this.userMapper.updateByPrimaryKeySelective(user);
                userId = user.getId();
                this.userAuthService.addUserAuth((byte)3, userId, userParam.getUnionId(), null);
                this.userAccountService.createUserAccount(userId);
                if (userParam.getInviteUserId() != null && userParam.getTaskInvited().booleanValue()) {
                    this.addInviteGoldAndPushMsg(userParam, 0);
                }
                this.missionIntegrationService.asyncCompleteTask(userId, TaskEnum.TASK_FIRST_LOGIN, String.valueOf(userId));
                isInsertInviteRecord = true;
            }
        } else {
            userId = unionUserAuth.getUserId();
            this.updateUserAuth(openUserAuth, userId);
            User existedUser = this.userMapper.selectByUserId(userId.longValue());
            isInsertInviteRecord = this.updateUserInvitation(user, existedUser);
            if (userParam.getInviteUserId() != null && existedUser != null) {
                this.addInviteGoldAndPushMsg(userParam, 1);
            }
        }
        this.loadUserToRedis(userId);
        this.logger.debug("\u5c0f\u7a0b\u5e8f\u6388\u6743\u767b\u9646\u79fb\u9664\u7528\u6237[{}]\u5728redis\u7684\u7f13\u5b58", (Object)userId);
        this.addInviteRecord(userParam, userId, isInsertInviteRecord);
        return message.addParam("userId", (Object)userId);
    }

    private void addInviteGoldAndPushMsg(TempUserParam userParam, Integer userType) {
        Integer userGold;
        if (0 == userType) {
            userGold = this.userProperties.getNewUserGold();
        } else if (1 == userType) {
            userGold = this.userProperties.getOldUserGold();
        } else {
            return;
        }
        this.userAccountService.addGold(new AccountGoldParam(userParam.getInviteUserId(), GoldEnum.USABLE_GOLD.name(), Boolean.valueOf(true), userGold, null, GoldFlowTypeEnum.TASK_INVITE_FRIEND.name()));
        this.pushMsgIntegrationService.pushInviteMsg(userParam.getInviteUserId(), userParam.getHeadImg(), userParam.getNickName(), userGold, userType);
    }

    private void updateUserAuth(UserAuth openUserAuth, Long userId) {
        if (!userId.equals(openUserAuth.getUserId())) {
            this.userAuthMapper.removeAuth(Byte.valueOf((byte)8), userId);
            this.userAuthMapper.removeAuth(Byte.valueOf((byte)8), openUserAuth.getUserId());
            openUserAuth.setId(Long.valueOf(this.nextId()));
            openUserAuth.setUserId(userId);
            this.userAuthMapper.insertSelective(openUserAuth);
        }
    }

    private void addInviteRecord(TempUserParam userParam, Long userId, Boolean isInsertInviteRecord) {
        if (isInsertInviteRecord.booleanValue() && userParam.getInviteUserId() != null && !userParam.getInviteUserId().equals(userId)) {
            this.inviteRecordService.addInviteRecord(userParam.getInviteUserId(), userId, userParam.getInviteType());
            RecordWechatParam recordWechatParam = new RecordWechatParam();
            recordWechatParam.setUserId(userParam.getInviteUserId());
            recordWechatParam.setWechatUid(userParam.getUnionId());
            recordWechatParam.setWechatImg(userParam.getHeadImg());
            recordWechatParam.setWechatName(userParam.getNickName());
            this.logger.debug("\u6dfb\u52a0VIP\u9080\u8bf7\u8bb0\u5f55: \u9080\u8bf7\u4eba\uff1a[{}], \u53d7\u9080\u4eba\uff1a[{}]", (Object)userParam.getInviteUserId(), (Object)userParam.getUnionId());
            this.vipIntegrationService.saveTempViewRecord(recordWechatParam);
        }
    }

    private void convertTempUser(TempUserParam tempUserParam, User user) {
        user.setWeixin(tempUserParam.getUnionId());
        user.setNickname(EmojiCodeParser.replaceSoftbankEmoji((String)tempUserParam.getNickName()));
        user.setHeadImg(tempUserParam.getHeadImg());
        Long userId = user.getId() == null ? Long.valueOf(this.nextId()) : user.getId();
        String headImg = this.extendedService.uploadHeadImg(tempUserParam.getHeadImg(), userId);
        if (StringUtils.isNotEmpty((CharSequence)headImg)) {
            user.setHeadImg(headImg);
        }
        user.setSex(tempUserParam.getSex());
        user.setRegIp(tempUserParam.getRegIp());
        user.setRegisterClient(tempUserParam.getPlatform());
        user.setRegisteredAddress(tempUserParam.getRegisteredAddress());
        user.setRelationId(tempUserParam.getRelationId());
        user.setLocationCode(tempUserParam.getLocationCode());
        user.setLocationName(tempUserParam.getLocationName());
        user.setInviteUserId(tempUserParam.getInviteUserId());
        User inviteUser = this.userMapper.selectByPrimaryKey(tempUserParam.getInviteUserId());
        if (inviteUser == null) {
            this.logger.info("\u53d7\u9080\u7528\u6237[{}]\u7684\u9080\u8bf7\u4eba\u4e0d\u5b58\u5728\uff0c\u8bf7\u6c42\u53c2\u6570:[{}]", (Object)user.getId(), (Object)tempUserParam);
            user.setInviteLevel(Integer.valueOf(1));
        } else {
            this.logger.info("\u521b\u5efa\u9080\u8bf7\u7528\u6237[{}]\u7684\u53d7\u9080\u7528\u6237", (Object)inviteUser.getId());
            user.setInviteLevel(Integer.valueOf(inviteUser.getInviteLevel() + 1));
        }
        user.setRegisterChannel(tempUserParam.getInviteType());
        user.setState(Byte.valueOf((byte)2));
        user.setLevel(LevelEnum.INITIAL_USER.getType());
        user.setIsNew(Byte.valueOf((byte)0));
        user.setIsTempNickName(Byte.valueOf((byte)1));
        user.setIsTempHeadImg(Byte.valueOf((byte)1));
        user.setNewbieGuideFlag(Byte.valueOf((byte)0));
    }

    private boolean updateUserInvitation(User user, User existedUser) {
        if (null != existedUser && existedUser.getState() == 2 && null == existedUser.getInviteUserId() && null != user.getInviteUserId()) {
            user.setId(existedUser.getId());
            user.setState(existedUser.getState());
            this.userMapper.updateByPrimaryKeySelective(user);
            return true;
        }
        return false;
    }

    @Override
    public BaseUserInfo getNickNameAndHeadImg(Long userId) {
        UserInfoDTO user = this.getUserFromRedisDB(userId);
        BaseUserInfo baseUserInfo = null;
        if (null != user) {
            baseUserInfo = new BaseUserInfo();
            BeanUtils.copyProperties((Object)user, (Object)baseUserInfo);
        }
        return baseUserInfo;
    }

    @Override
    public List<UserInfoDTO> getBatchUserInfo(Collection<Long> userIds) {
        List<String> paramList = userIds.stream().map(String::valueOf).collect(Collectors.toList());
        List userCaches = this.redisHashMapAdapter.multiGet(RedisConfig.USER_INFO, paramList, String.class);
        ArrayList userInfos = Lists.newArrayList();
        userCaches.forEach(e -> {
            UserInfoDTO userInfoDTO = (UserInfoDTO)JSON.parseObject((String)e, UserInfoDTO.class);
            if (null != userInfoDTO) {
                paramList.remove(userInfoDTO.getId().toString());
                userInfos.add(userInfoDTO);
            }
        });
        if (!CollectionUtils.isEmpty(paramList)) {
            paramList.forEach(e -> {
                UserInfoDTO userInfoDTO = this.loadUserToRedis(Long.valueOf(e));
                if (null != userInfoDTO) {
                    userInfos.add(userInfoDTO);
                }
            });
        }
        return userInfos;
    }

    @Override
    @Async
    public void isRisk(Long userId, String phone, BasicParam basicParam, String deviceToken, String ip) {
        boolean isRiskNum;
        boolean bl = isRiskNum = StringUtils.isNotEmpty((CharSequence)phone) && phone.startsWith("170") || phone.startsWith("171");
        if (isRiskNum) {
            this.userMapper.updateUserToRisk(userId);
        } else if (this.checkRisk(phone, basicParam, deviceToken, ip).booleanValue()) {
            this.userMapper.updateUserToRisk(userId);
        }
    }

    @Override
    public String getGeneration(LocalDate birthday) {
        String generationStr = null;
        if (null != birthday) {
            int year = birthday.getYear();
            int decade = year / 10;
            String s = String.valueOf(decade);
            generationStr = s.substring(s.length() - 1) + "0\u540e";
        }
        return generationStr;
    }

    @Override
    public UserTbkInfo selectUserFromCacheByRelationId(String relationId) {
        User user = this.userMapper.selectUserByRelationId(relationId);
        if (Objects.isNull(user)) {
            return null;
        }
        UserTbkInfo info = new UserTbkInfo();
        info.setId(user.getId());
        info.setTbkSpecialId(user.getTbkSpecialId());
        info.setTbkRelationId(user.getTbkRelationId());
        info.setSuperiorUserId(user.getInviteUserId());
        info.setTopUserId(null);
        info.setIsVip(Boolean.valueOf(false));
        return info;
    }

    private Boolean checkRisk(String phone, BasicParam basicParam, String deviceToken, String ip) {
        String operateSource = "";
        if (basicParam.getPlatform() == 1) {
            operateSource = "ANDROID";
        } else if (basicParam.getPlatform() == 2) {
            operateSource = "IOS";
        }
        RiskParam riskParam = new RiskParam();
        riskParam.setDeviceToken(deviceToken);
        riskParam.setIp(ip);
        riskParam.setOperateSource(operateSource);
        riskParam.setPhone(phone);
        EquipmentDTO equipmentDTO = this.bizIntegrationService.getDevice(basicParam.getDevcId());
        if (null != equipmentDTO && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{equipmentDTO.getId()})) {
            riskParam.setEquiment(equipmentDTO.getId());
            riskParam.setOperateSystem(equipmentDTO.getPhoneModel());
        }
        return this.riskRecordService.checkRiskDevice(riskParam);
    }
}

