/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.support.impl;

import com.bxm.localnews.user.domain.UserEquipmentMapper;
import com.bxm.localnews.user.dto.EquipmentDTO;
import com.bxm.localnews.user.dto.h5.ClientVersionDto;
import com.bxm.localnews.user.integration.BizIntegrationService;
import com.bxm.localnews.user.support.UserEquipmentService;
import com.bxm.localnews.user.vo.UserEquipment;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class UserEquipmentServiceImpl
implements UserEquipmentService {
    @Resource
    private UserEquipmentMapper userEquipmentMapper;
    @Resource
    private BizIntegrationService bizIntegrationService;

    @Override
    public UserEquipment selectByEquipment(String equipment) {
        return this.userEquipmentMapper.selectByEquipment(equipment);
    }

    @Override
    public Message addUserEquipment(UserEquipment userEquipment) {
        this.userEquipmentMapper.addEquipment(userEquipment);
        return Message.build();
    }

    @Override
    public Message checkExistEquipment(String equipment, String activityType) {
        EquipmentDTO equipmentDTO = this.bizIntegrationService.getDevice(equipment);
        if (null != equipmentDTO && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{equipmentDTO.getId()})) {
            boolean isEquipmentExist = this.userEquipmentMapper.countEquipment(equipmentDTO.getId(), activityType) > 0;
            return Message.build((boolean)isEquipmentExist).addParam("id", (Object)equipmentDTO.getId());
        }
        return Message.build((boolean)true);
    }

    @Override
    public ClientVersionDto queryClientVersion(Long userId, String curVer) {
        ClientVersionDto clientVersion = this.userEquipmentMapper.queryClientVersion(userId);
        if (null == clientVersion) {
            clientVersion = new ClientVersionDto();
            clientVersion.setCompareResult(-1);
            clientVersion.setVersion("1.0.0");
        } else {
            clientVersion.setCompareResult(StringUtils.compareVersion((String)curVer, (String)clientVersion.getVersion()));
        }
        return clientVersion;
    }
}

