/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.support.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.mq.common.constant.UserRecommendEnum;
import com.bxm.localnews.mq.common.model.dto.UserRecommendDTO;
import com.bxm.localnews.user.account.UserAccountService;
import com.bxm.localnews.user.attribute.UserVisitService;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.domain.UserLocationHistoryMapper;
import com.bxm.localnews.user.domain.UserMapper;
import com.bxm.localnews.user.domain.UserStatisticsMapper;
import com.bxm.localnews.user.dto.LocationDTO;
import com.bxm.localnews.user.dto.UserBaseInfoDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.enums.ExtraInviteStateEnum;
import com.bxm.localnews.user.integration.AppVersionIntegrationService;
import com.bxm.localnews.user.integration.BizLogIntegrationService;
import com.bxm.localnews.user.integration.LocationIntegrationService;
import com.bxm.localnews.user.integration.MessageUserIntegrationService;
import com.bxm.localnews.user.integration.UserNewsIntegrationService;
import com.bxm.localnews.user.integration.UserRecommendSourceIntegrationService;
import com.bxm.localnews.user.login.UserParamCheckService;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.param.UserLocationParam;
import com.bxm.localnews.user.properties.BizConfigProperties;
import com.bxm.localnews.user.properties.UserProperties;
import com.bxm.localnews.user.support.UserInternalService;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserLocationHistory;
import com.bxm.newidea.component.enums.FileTypeEnum;
import com.bxm.newidea.component.oss.config.AliyunOssProperties;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.FileUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class UserInternalServiceImpl
extends BaseService
implements UserInternalService {
    private UserAccountService userAccountService;
    private UserMapper userMapper;
    private UserProperties userProperties;
    private RedisStringAdapter redisStringAdapter;
    private UserLocationHistoryMapper userLocationHistoryMapper;
    private LocationIntegrationService locationIntegrationService;
    private AliyunOSSService aliyunOSSService;
    private AliyunOssProperties aliyunOssProperties;
    private BizConfigProperties bizConfigProperties;
    private BizLogIntegrationService bizLogIntegrationService;
    private UserNewsIntegrationService userNewsIntegrationService;
    private AppVersionIntegrationService appVersionIntegrationService;
    private UserParamCheckService userParamCheckService;
    private UserService userService;
    private UserVisitService userVisitService;
    private UserStatisticsMapper userStatisticsMapper;
    private UserRecommendSourceIntegrationService userRecommendSourceIntegrationService;
    private MessageUserIntegrationService messageUserIntegrationService;

    @Override
    public LocationDTO doPostingLocation(String code, Long userId, BasicParam basicParam, String ip) {
        Message message = this.userParamCheckService.checkPostLocationParam(code, userId);
        if (!message.isSuccess()) {
            this.logger.error(message.getLastMessage());
        }
        if (null == code) {
            code = this.bizConfigProperties.getLocationCode();
        }
        LocationDTO locationDTO = this.locationIntegrationService.getLocationByGeocode(code);
        if (this.appVersionIntegrationService.getPublishState(basicParam).booleanValue()) {
            locationDTO.setEnablePaidPromote(Byte.valueOf((byte)0));
            locationDTO.setEnableCommunityContent(Integer.valueOf(0));
            locationDTO.setEnableIndexPublish(Integer.valueOf(0));
        }
        if (null != userId) {
            locationDTO.setPublishPostNum(this.userNewsIntegrationService.getPublishPostNum(userId));
            if (!this.redisStringAdapter.hasKey(RedisConfig.NEW_USER_LOGIN.copy().appendKey((Object)userId)).booleanValue()) {
                this.userAccountService.updateInviteUserCash(userId, ExtraInviteStateEnum.LOGIN_TWICE);
            }
            ((UserInternalService)SpringContextHolder.getBean(UserInternalService.class)).afterPostingLocation(locationDTO, userId, basicParam, ip);
        } else {
            locationDTO.setPublishPostNum(Integer.valueOf(0));
        }
        return locationDTO;
    }

    @Override
    @Async
    public void afterPostingLocation(LocationDTO locationDTO, Long userId, BasicParam basicParam, String ip) {
        User user = this.userMapper.selectByPrimaryKey(userId);
        if (null != user && StringUtils.notEquals((CharSequence)user.getLocationCode(), (CharSequence)locationDTO.getCode())) {
            user.setLocationCode(locationDTO.getCode());
            user.setLocationName(locationDTO.getName());
            this.logger.debug("\u7528\u6237\u8fdb\u884c\u5b9a\u4f4d\uff0c\u4e0d\u540c\u4e8e\u5386\u53f2\u5b9a\u4f4d\u4fe1\u606f\uff0c\u8fdb\u884c\u66f4\u65b0:[{}]", (Object)JSONObject.toJSONString((Object)user));
            this.userMapper.updateLocationByPrimaryKeySelective(user);
            this.userService.loadUserToRedis(userId);
            UserLocationHistory userLocationHistory = new UserLocationHistory();
            userLocationHistory.setAddTime(new Date());
            userLocationHistory.setId(this.nextSequence());
            userLocationHistory.setLocationCode(locationDTO.getCode());
            userLocationHistory.setUserId(userId);
            this.userLocationHistoryMapper.insert(userLocationHistory);
            this.logger.debug("\u4f4d\u7f6e\u5386\u53f2\u8868\u65b0\u589e:[{}]", (Object)JSONObject.toJSONString((Object)userLocationHistory));
            this.bizLogIntegrationService.changeArea(userId, locationDTO.getCode(), null);
            if (StringUtils.isNotBlank((CharSequence)locationDTO.getCode())) {
                UserRecommendDTO attributeRecommendDTO = new UserRecommendDTO();
                attributeRecommendDTO.setUserId(user.getId());
                attributeRecommendDTO.setRecommendType(UserRecommendEnum.USER_ATTRIBUTE.getTag());
                attributeRecommendDTO.setLocationCode(locationDTO.getCode());
                this.userRecommendSourceIntegrationService.pushUserRecommendInfo(attributeRecommendDTO);
            }
        }
    }

    @Override
    public String getUserHeaderImg(Long userId) {
        UserInfoDTO userInfoDTO = this.userService.getUserFromRedisDB(userId);
        if (userInfoDTO == null) {
            return this.userProperties.getDefaultHeadImgUrl();
        }
        String urlString = userInfoDTO.getHeadImg();
        if (StringUtils.isBlank((CharSequence)userInfoDTO.getHeadImg())) {
            return this.userProperties.getDefaultHeadImgUrl();
        }
        if (StringUtils.startsWith((CharSequence)urlString, (CharSequence)this.aliyunOssProperties.getCdnUrl())) {
            this.logger.debug("hit cache headimg:{}", (Object)userId);
            return urlString;
        }
        try {
            String fileExt = FileUtils.getFilextension((String)urlString);
            if (FileTypeEnum.getContentType((String)fileExt) == null) {
                fileExt = FileTypeEnum.JPG.getExtName();
            }
            URL url = new URL(urlString);
            BufferedInputStream dis = new BufferedInputStream(url.openStream());
            int hashCode = (int)(userId % 10L);
            String imgUrl = this.aliyunOSSService.upload((InputStream)dis, "avatar/" + hashCode + "/" + userId + "." + fileExt);
            userInfoDTO.setHeadImg(imgUrl);
            this.userService.loadUserToRedis(userId);
            return imgUrl;
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public UserBaseInfoDTO getUserPersonalCenterInfo(Long userId, int platform) {
        UserInfoDTO user = this.userService.getUserFromRedisDB(userId);
        if (null == user) {
            return null;
        }
        UserBaseInfoDTO userBaseInfoDTO = new UserBaseInfoDTO();
        userBaseInfoDTO.setNickname(StringUtils.isBlank((CharSequence)user.getNickname()) ? StringUtils.hideMobile((String)user.getPhone()) : user.getNickname());
        userBaseInfoDTO.setHeadImg(StringUtils.isBlank((CharSequence)user.getHeadImg()) ? this.userProperties.getDefaultHeadImgUrl() : user.getHeadImg());
        userBaseInfoDTO.setForumNum(user.getPostNum());
        userBaseInfoDTO.setSex(user.getSex());
        userBaseInfoDTO.setAttentionNum(user.getAttentionNum());
        userBaseInfoDTO.setFanNum(user.getFanNum());
        userBaseInfoDTO.setPersonalProfile(user.getPersonalProfile());
        userBaseInfoDTO.setAllInterviewNum(this.userVisitService.getInterviewNumByUserId(userId));
        userBaseInfoDTO.setInviteNum(Integer.valueOf(0));
        userBaseInfoDTO.setMaterialFinished(Boolean.valueOf(false));
        userBaseInfoDTO.setUnReadFanNum(this.messageUserIntegrationService.getUnReadMessageNum(userId, "ADD_FUNS"));
        userBaseInfoDTO.setRedPoint(Boolean.valueOf(false));
        userBaseInfoDTO.setNoticeNum(Integer.valueOf(0));
        userBaseInfoDTO.setTodayInterviewNum(this.userVisitService.getTodayVisitorNum(userId));
        userBaseInfoDTO.setUserCashGoldDTO(this.userAccountService.getUserCashGold(userId));
        return userBaseInfoDTO;
    }

    @Override
    public int countRegUser(String startTime, String endTime) {
        return this.userStatisticsMapper.countRegUser(startTime, endTime);
    }

    @Override
    public Boolean postUserPositionAndLoginInfo(UserLocationParam userLocationParam) {
        this.logger.info("\u4e0a\u62a5\u7528\u6237\u5b9a\u4f4d\u4ee5\u53ca\u6d3b\u8dc3\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)userLocationParam));
        UserRecommendDTO behaviorRecommendDTO = new UserRecommendDTO();
        behaviorRecommendDTO.setUserId(userLocationParam.getUserId());
        behaviorRecommendDTO.setRecommendType(UserRecommendEnum.USER_BEHAVIOR.getTag());
        behaviorRecommendDTO.setLastLoginTime(new Date());
        this.userRecommendSourceIntegrationService.pushUserRecommendInfo(behaviorRecommendDTO);
        UserRecommendDTO positionRecommendDTO = new UserRecommendDTO();
        positionRecommendDTO.setLongitude(userLocationParam.getLongitude());
        positionRecommendDTO.setLatitude(userLocationParam.getLatitude());
        positionRecommendDTO.setUserId(userLocationParam.getUserId());
        LocationDTO locationByGeocode = this.locationIntegrationService.getLocationByGeocode(userLocationParam.getAreaCode());
        if (null != locationByGeocode && StringUtils.isNotBlank((CharSequence)locationByGeocode.getCode())) {
            positionRecommendDTO.setCurrentAreaCode(locationByGeocode.getCode());
        }
        positionRecommendDTO.setRecommendType(UserRecommendEnum.USER_POSITION.getTag());
        this.userRecommendSourceIntegrationService.pushUserRecommendInfo(positionRecommendDTO);
        return true;
    }

    @Autowired
    public UserInternalServiceImpl(UserAccountService userAccountService, UserMapper userMapper, UserProperties userProperties, RedisStringAdapter redisStringAdapter, UserLocationHistoryMapper userLocationHistoryMapper, LocationIntegrationService locationIntegrationService, AliyunOSSService aliyunOSSService, AliyunOssProperties aliyunOssProperties, BizConfigProperties bizConfigProperties, BizLogIntegrationService bizLogIntegrationService, UserNewsIntegrationService userNewsIntegrationService, AppVersionIntegrationService appVersionIntegrationService, UserParamCheckService userParamCheckService, UserService userService, UserVisitService userVisitService, UserStatisticsMapper userStatisticsMapper, UserRecommendSourceIntegrationService userRecommendSourceIntegrationService, MessageUserIntegrationService messageUserIntegrationService) {
        this.userAccountService = userAccountService;
        this.userMapper = userMapper;
        this.userProperties = userProperties;
        this.redisStringAdapter = redisStringAdapter;
        this.userLocationHistoryMapper = userLocationHistoryMapper;
        this.locationIntegrationService = locationIntegrationService;
        this.aliyunOSSService = aliyunOSSService;
        this.aliyunOssProperties = aliyunOssProperties;
        this.bizConfigProperties = bizConfigProperties;
        this.bizLogIntegrationService = bizLogIntegrationService;
        this.userNewsIntegrationService = userNewsIntegrationService;
        this.appVersionIntegrationService = appVersionIntegrationService;
        this.userParamCheckService = userParamCheckService;
        this.userService = userService;
        this.userVisitService = userVisitService;
        this.userStatisticsMapper = userStatisticsMapper;
        this.userRecommendSourceIntegrationService = userRecommendSourceIntegrationService;
        this.messageUserIntegrationService = messageUserIntegrationService;
    }
}

