/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.support.impl;

import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.user.domain.UserSyncMapper;
import com.bxm.localnews.user.integration.IMIntegrationService;
import com.bxm.localnews.user.integration.UserNewsIntegrationService;
import com.bxm.localnews.user.param.UserSyncParam;
import com.bxm.localnews.user.support.UserSyncService;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserSync;
import com.bxm.newidea.component.service.BaseService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserSyncServiceImpl
extends BaseService
implements UserSyncService {
    @Resource
    private UserNewsIntegrationService userNewsIntegrationService;
    @Resource
    private IMIntegrationService imIntegrationService;

    @Override
    public void sync(UserSyncParam user) {
        this.userNewsIntegrationService.syncUser(user);
        this.imIntegrationService.syncUser(user.getId());
    }

    @Override
    @Async
    public void batchSync(List<User> userList) {
        if (CollectionUtils.isEmpty(userList)) {
            return;
        }
        List userSyncList = userList.stream().map(this::convertUserToUserSync).collect(Collectors.toList());
        MybatisBatchBuilder.create(UserSyncMapper.class, userSyncList).run(UserSyncMapper::updateInviteRecord);
        MybatisBatchBuilder.create(UserSyncMapper.class, userSyncList).run(UserSyncMapper::updateHelpInfo);
        MybatisBatchBuilder.create(UserSyncMapper.class, userSyncList).run(UserSyncMapper::updateMarketOrder);
        MybatisBatchBuilder.create(UserSyncMapper.class, userSyncList).run(UserSyncMapper::updateRedPacketObtainHistory);
    }

    private UserSync convertUserToUserSync(User user) {
        UserSync userSync = new UserSync();
        userSync.setUserId(user.getId());
        userSync.setNickname(user.getNickname());
        return userSync;
    }
}

