package com.bxm.localnews.user.account;

import com.bxm.localnews.user.param.DeductPointParam;
import com.bxm.localnews.user.param.StoreNeceParam;
import java.math.BigDecimal;

/**
 * @author zhaoyadong 2019/3/14 20:50
 * @desc
 */
public interface AccountService {

    /**
     * 获取积分商城用户金币
     */
    BigDecimal selectGoldByUserId(StoreNeceParam storeNeceParam);

    /**
     * 扣除用户金币
     */
    Boolean deductUserGold(DeductPointParam deductPointParam);

    /**
     * 确认扣除用户金币
     */
    void deductConfirmUserGold(DeductPointParam deductPointParam);

    /**
     * 用户添加金币
     */
    void addUserGold(DeductPointParam deductPointParam);

    /**
     * 获取用户金币余额
     *
     * @param userId 用户id
     */
    BigDecimal selectUsableGoldByUserId(Long userId);
}
